/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.os.Build;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.Tls12SocketFactory;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;

public class TlsUtil {
    private static final String TAG = "TlsUtil";
    private static final String TLS_1_2 = "TLSv1.2";

    public static void enableTls12ForKitKat(OkHttpClient.Builder client) {
        if (Build.VERSION.SDK_INT == 19) {
            try {
                SSLContext sc = SSLContext.getInstance(TLS_1_2);
                sc.init(null, null, null);
                client.sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(sc.getSocketFactory()), TlsUtil.systemDefaultTrustManager());
                ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
                ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
                specs.add(cs);
                specs.add(ConnectionSpec.COMPATIBLE_TLS);
                specs.add(ConnectionSpec.CLEARTEXT);
                client.connectionSpecs(specs);
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000002B, "Error while setting TLS 1.2", e);
            }
        }
    }

    private static X509TrustManager systemDefaultTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }
}

