package com.liveperson.infra.model;

/**
 * Created by nirni on 9/7/17.
 *
 * This class represents the required data returned from LPTag.
 *
 * 1. If we got data from LPTag:
 * 	a. AutoMessage Feature Enabled
 *
 * 2. If we got a Retry response from LPTag:
 * 	a. Retry timeout
 * 	b. Max retries
 */
public class LptagData {

	// Retries
	private int mRetryTimeout = 0;
	private int mMaxRetries = 0;

	// Features
	private boolean mAutoMessagesFeatureEnabled = false;


	public boolean isAutoMessagesFeatureEnabled() {
		return mAutoMessagesFeatureEnabled;
	}

	public void setAutoMessagesFeatureEnabled(boolean autoMessagesFeatureEnabled) {
		mAutoMessagesFeatureEnabled = autoMessagesFeatureEnabled;
	}

	public int getRetryTimeout() {
		return mRetryTimeout;
	}

	public void setRetryTimeout(int retryTimeout) {
		mRetryTimeout = retryTimeout;
	}

	public int getMaxRetries() {
		return mMaxRetries;
	}

	public void setMaxRetries(int maxRetries) {
		mMaxRetries = maxRetries;
	}
}
