/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.model;

import com.nimbusds.jose.jwk.JWK;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/liveperson/infra/model/JWKInfo;", "", "jwk", "Lcom/nimbusds/jose/jwk/JWK;", "kId", "", "(Lcom/nimbusds/jose/jwk/JWK;Ljava/lang/String;)V", "getJwk", "()Lcom/nimbusds/jose/jwk/JWK;", "getKId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "infra_release"})
public final class JWKInfo {
    @NotNull
    private final JWK jwk;
    @NotNull
    private final String kId;

    @NotNull
    public final JWK getJwk() {
        return this.jwk;
    }

    @NotNull
    public final String getKId() {
        return this.kId;
    }

    public JWKInfo(@NotNull JWK jwk, @NotNull String kId) {
        Intrinsics.checkParameterIsNotNull((Object)jwk, (String)"jwk");
        Intrinsics.checkParameterIsNotNull((Object)kId, (String)"kId");
        this.jwk = jwk;
        this.kId = kId;
    }

    @NotNull
    public final JWK component1() {
        return this.jwk;
    }

    @NotNull
    public final String component2() {
        return this.kId;
    }

    @NotNull
    public final JWKInfo copy(@NotNull JWK jwk, @NotNull String kId) {
        Intrinsics.checkParameterIsNotNull((Object)jwk, (String)"jwk");
        Intrinsics.checkParameterIsNotNull((Object)kId, (String)"kId");
        return new JWKInfo(jwk, kId);
    }

    public static /* synthetic */ JWKInfo copy$default(JWKInfo jWKInfo, JWK jWK, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            jWK = jWKInfo.jwk;
        }
        if ((n & 2) != 0) {
            string2 = jWKInfo.kId;
        }
        return jWKInfo.copy(jWK, string2);
    }

    @NotNull
    public String toString() {
        return "JWKInfo(jwk=" + this.jwk + ", kId=" + this.kId + ")";
    }

    public int hashCode() {
        JWK jWK = this.jwk;
        String string2 = this.kId;
        return (jWK != null ? jWK.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JWKInfo)) break block3;
                JWKInfo jWKInfo = (JWKInfo)object;
                if (!Intrinsics.areEqual((Object)this.jwk, (Object)jWKInfo.jwk) || !Intrinsics.areEqual((Object)this.kId, (Object)jWKInfo.kId)) break block3;
            }
            return true;
        }
        return false;
    }
}

