/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.model;

import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.utils.EncryptionVersion;

public class Message {
    public static final String EXTRA_MESSAGE_TEXT = "EXTRA_MESSAGE_TEXT";
    private int mServerSequence = -1;
    private String mMessage;
    private String metadata;
    private String mContentType = "text/plain";
    protected long mId;
    private String mDialogId;
    private long mTimeStamp;
    private String mOriginatorId;
    private String mEventId;

    public Message(String originatorId, String message, long timeStamp, String dialogId, String eventId, EncryptionVersion encryptionVersion) {
        this.mOriginatorId = originatorId;
        this.mMessage = DBEncryptionHelper.decrypt(encryptionVersion, message);
        this.mTimeStamp = timeStamp;
        this.mDialogId = dialogId;
        this.mEventId = eventId;
    }

    public String toString() {
        return String.format("Message %s\nDialog id %s\nTimeStamp %s\nEventId %s\nServerSequence %s\nOriginatorId %s", this.mMessage, this.mDialogId, this.mTimeStamp, this.mEventId, this.mServerSequence, this.mOriginatorId);
    }

    public long getLocalId() {
        return this.mId;
    }

    public void setMessageId(long messageId) {
        this.mId = messageId;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public long getTimeStamp() {
        return this.mTimeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.mTimeStamp = timeStamp;
    }

    public String getDialogId() {
        return this.mDialogId;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public int getServerSequence() {
        return this.mServerSequence;
    }

    public String getOriginatorId() {
        return this.mOriginatorId;
    }

    public void setDialogId(String dialogId) {
        this.mDialogId = dialogId;
    }

    public void setContentType(String contentType) {
        this.mContentType = contentType;
    }

    public void setEventId(String eventId) {
        this.mEventId = eventId;
    }

    public String getEventId() {
        return this.mEventId;
    }

    public void setServerSequence(int serverSequence) {
        this.mServerSequence = serverSequence;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }
}

