/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.JWKInfo;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import java.net.URL;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/liveperson/infra/network/http/requests/JWKSRequest;", "Lcom/liveperson/infra/Command;", "domain", "", "callback", "Lcom/liveperson/infra/ICallback;", "Lcom/liveperson/infra/model/JWKInfo;", "Ljava/lang/Exception;", "(Ljava/lang/String;Lcom/liveperson/infra/ICallback;)V", "getCallback", "()Lcom/liveperson/infra/ICallback;", "getDomain", "()Ljava/lang/String;", "execute", "", "Companion", "infra_release"})
public final class JWKSRequest
implements Command {
    @NotNull
    private final String domain;
    @NotNull
    private final ICallback<JWKInfo, Exception> callback;
    private static final String TAG = "JWKSRequest";
    private static final String LP_JWKS_URL = "https://%s/well-known/jwks";
    private static final int connectTimeout = 30000;
    private static final int readTimeout = 30000;
    private static final int sizeLimit = 300000;
    public static final Companion Companion = new Companion(null);

    @Override
    public void execute() {
        JWK jwk;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = LP_JWKS_URL;
        Object[] objectArray = new Object[]{this.domain};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String jwksUrl = string2;
        JWKSet jwkSet = null;
        try {
            jwkSet = JWKSet.load((URL)new URL(jwksUrl), (int)30000, (int)30000, (int)300000);
        }
        catch (Exception e) {
            LPLog.INSTANCE.d(TAG, "Failed to load jwkSet from: " + jwksUrl);
            this.callback.onError((Exception)((Throwable)e));
        }
        if (jwkSet == null || jwkSet.size() <= 0) {
            LPLog.INSTANCE.d(TAG, "jwkSet is blank");
            this.callback.onSuccess(null);
            return;
        }
        Object e = jwkSet.getKeys().get(0);
        Intrinsics.checkExpressionValueIsNotNull(e, (String)"jwkSet.keys[0]");
        String kId = ((JWK)e).getKeyID();
        JWK jWK = jwk = jwkSet.getKeyByKeyId(kId);
        Intrinsics.checkExpressionValueIsNotNull((Object)jWK, (String)"jwk");
        String string3 = kId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"kId");
        this.callback.onSuccess(new JWKInfo(jWK, string3));
    }

    @NotNull
    public final String getDomain() {
        return this.domain;
    }

    @NotNull
    public final ICallback<JWKInfo, Exception> getCallback() {
        return this.callback;
    }

    public JWKSRequest(@NotNull String domain, @NotNull ICallback<JWKInfo, Exception> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        this.domain = domain;
        this.callback = callback2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/liveperson/infra/network/http/requests/JWKSRequest$Companion;", "", "()V", "LP_JWKS_URL", "", "TAG", "connectTimeout", "", "readTimeout", "sizeLimit", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

