/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.util.Base64;
import com.liveperson.infra.model.PKCEParams;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0002J \u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/liveperson/infra/utils/PKCEUtils;", "", "()V", "JWE_ALGORITHM", "Lcom/nimbusds/jose/JWEAlgorithm;", "kotlin.jvm.PlatformType", "JWE_ENCRYPTION_METHOD", "Lcom/nimbusds/jose/EncryptionMethod;", "generateCodeChallenge", "", "codeVerifier", "generateCodeVerifier", "generateEncryptedCodeVerifier", "kId", "jwk", "Lcom/nimbusds/jose/jwk/JWK;", "generatePKCEParams", "Lcom/liveperson/infra/model/PKCEParams;", "infra_release"})
public final class PKCEUtils {
    private static final JWEAlgorithm JWE_ALGORITHM;
    private static final EncryptionMethod JWE_ENCRYPTION_METHOD;
    public static final PKCEUtils INSTANCE;

    private final String generateCodeChallenge(String codeVerifier) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String string2 = codeVerifier;
        Object object = "US-ASCII";
        boolean bl = false;
        Charset charset = Charset.forName((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
        object = charset;
        bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        Intrinsics.checkExpressionValueIsNotNull((Object)messageDigest, (String)"MessageDigest.getInstance(\"SHA-256\")");
        MessageDigest messageDigest2 = messageDigest;
        messageDigest2.update(bytes, 0, bytes.length);
        byte[] byArray2 = messageDigest2.digest();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"messageDigest.digest()");
        byte[] digest = byArray2;
        int base64Flags = 11;
        String string4 = Base64.encodeToString((byte[])digest, (int)base64Flags);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Base64.encodeToString(digest, base64Flags)");
        return string4;
    }

    private final String generateCodeVerifier() throws UnsupportedEncodingException {
        int minLength = 43;
        int maxLength = 128;
        SecureRandom secureRandom = new SecureRandom();
        int codeVerifierLength = secureRandom.nextInt(maxLength - minLength + 1) + minLength;
        byte[] codeVerifier = new byte[128];
        secureRandom.nextBytes(codeVerifier);
        int base64Flags = 11;
        String string2 = Base64.encodeToString((byte[])codeVerifier, (int)base64Flags);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64.encodeToString(codeVerifier, base64Flags)");
        String string3 = string2;
        int n = 0;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, codeVerifierLength);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string5;
    }

    private final String generateEncryptedCodeVerifier(String codeVerifier, String kId, JWK jwk) {
        String string2;
        String jsonCodeVerifier = "{\"code_verifier\":\"" + codeVerifier + "\"}";
        JWEHeader header = new JWEHeader.Builder(JWE_ALGORITHM, JWE_ENCRYPTION_METHOD).keyID(kId).build();
        Payload payload = new Payload(jsonCodeVerifier);
        JWEObject jweObject = new JWEObject(header, payload);
        if (jwk instanceof RSAKey) {
            RSAEncrypter encrypter = new RSAEncrypter(((RSAKey)jwk).toRSAPublicKey());
            jweObject.encrypt((JWEEncrypter)encrypter);
            String string3 = jweObject.serialize();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"jweObject.serialize()");
        } else {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public final PKCEParams generatePKCEParams(@NotNull String kId, @NotNull JWK jwk) {
        Intrinsics.checkParameterIsNotNull((Object)kId, (String)"kId");
        Intrinsics.checkParameterIsNotNull((Object)jwk, (String)"jwk");
        String codeVerifier = this.generateCodeVerifier();
        String codeChallenge = this.generateCodeChallenge(codeVerifier);
        String strJWE = this.generateEncryptedCodeVerifier(codeVerifier, kId, jwk);
        return new PKCEParams(strJWE, codeChallenge, null, 4, null);
    }

    private PKCEUtils() {
    }

    static {
        PKCEUtils pKCEUtils;
        INSTANCE = pKCEUtils = new PKCEUtils();
        JWE_ALGORITHM = JWEAlgorithm.RSA_OAEP_256;
        JWE_ENCRYPTION_METHOD = EncryptionMethod.A256GCM;
    }
}

