package com.liveperson.infra.database.transaction_helper;

import android.content.ContentValues;

/**
 * Created by shiranr on 13/01/2016.
 */
public class InsertOrUpdateSQLCommand extends UpdateSQLCommand {

	private ContentValues mContentValuesForInsert;

    public InsertOrUpdateSQLCommand(ContentValues contentValuesForInsert, ContentValues contentValuesForUpdate, String whereClause, String[] whereArgs) {
        super(contentValuesForUpdate, whereClause, whereArgs);
		mContentValuesForInsert = contentValuesForInsert;
    }

    @Override
    public int getType() {
        return CommandType.INSERT_OR_UPDATE;
    }

	public ContentValues getContentValuesForInsert() {
		return mContentValuesForInsert;
	}

	public ContentValues getContentValuesForUpdate() {
		return getContentValues();
	}

	/**
	 * Call this to indicate that the insert operation is completed. This will notify any registered listener.
	 */
	@Override
	public void onInserted(long rowId) {
		if (mListener != null) {
			mListener.onInsertComplete(rowId);
		}
	}

}
