/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.liveperson.infra.Infra;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LocalBroadcastReceiver {
    private static final Set<LPBroadcastReceiver> registeredReceivers = new HashSet<LPBroadcastReceiver>();
    private final IOnReceive mReceiver;
    private final LPBroadcastReceiver mLocalBroadcastManager;
    private final IntentFilter mIntentFilter;
    private boolean isRegistered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAll() {
        Set<LPBroadcastReceiver> set = registeredReceivers;
        synchronized (set) {
            Iterator<LPBroadcastReceiver> receiverIterator = registeredReceivers.iterator();
            while (receiverIterator.hasNext()) {
                LPBroadcastReceiver receiver = receiverIterator.next();
                if (receiver != null) {
                    receiver.unregisterReceiver();
                }
                receiverIterator.remove();
            }
        }
    }

    public void unregister() {
        this.isRegistered = false;
        this.mLocalBroadcastManager.unregister();
    }

    public void register() {
        this.isRegistered = true;
        this.mLocalBroadcastManager.register();
    }

    private LocalBroadcastReceiver(Builder builder, IOnReceive receiverCallback) {
        this.mIntentFilter = builder.mIntentFilter;
        this.mReceiver = receiverCallback;
        this.mLocalBroadcastManager = new LPBroadcastReceiver();
        this.register();
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public class LPBroadcastReceiver
    extends BroadcastReceiver {
        private LocalBroadcastManager broadcastManager = LocalBroadcastManager.getInstance((Context)Infra.instance.getApplicationContext());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register() {
            Set set = registeredReceivers;
            synchronized (set) {
                registeredReceivers.add(this);
            }
            this.broadcastManager.registerReceiver((BroadcastReceiver)this, LocalBroadcastReceiver.this.mIntentFilter);
        }

        public void onReceive(Context context, Intent intent) {
            LocalBroadcastReceiver.this.mReceiver.onBroadcastReceived(context, intent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            Set set = registeredReceivers;
            synchronized (set) {
                registeredReceivers.remove((Object)this);
            }
            this.broadcastManager.unregisterReceiver((BroadcastReceiver)this);
        }

        void unregisterReceiver() {
            this.broadcastManager.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public static class Builder {
        private IntentFilter mIntentFilter = new IntentFilter();

        public Builder addAction(String action) {
            this.mIntentFilter.addAction(action);
            return this;
        }

        public LocalBroadcastReceiver build(IOnReceive receiverCallback) {
            return new LocalBroadcastReceiver(this, receiverCallback);
        }
    }

    public static interface IOnReceive {
        public void onBroadcastReceived(Context var1, Intent var2);
    }
}

