/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.MessageOption;
import com.liveperson.infra.utils.EncryptionVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class LPWelcomeMessage
implements Parcelable {
    private static final String TAG = "LPWelcomeMessage";
    private static final int MAX_ITEMS = 24;
    private static final int MAX_MESSAGE_OPTION_LENGTH = 25;
    private static final int MIN_MESSAGE_OPTION_LENGTH = 1;
    private static final int DEFAULT_NUMBER_OF_ITEMS_PER_ROW = 8;
    private static final int WELCOME_MSG_SEQUENCE_NUMBER = -4;
    private static final String KEY_TYPE = "type";
    private static final String KEY_TOOLTIP = "tooltip";
    private static final String KEY_TITLE = "title";
    private static final String KEY_TEXT = "text";
    private static final String KEY_ACTIONS = "actions";
    private static final String KEY_METADATA = "metadata";
    private static final String KEY_CLICK = "click";
    private static final String KEY_ITEMS_PER_ROW = "itemsPerRow";
    private static final String KEY_REPLIES = "replies";
    private static final String KEY_QUICK_REPLIES = "quick_replies_key";
    private static final String KEY_TIME_STAMP = "timestamp_key";
    private static final String KEY_ORIGINATOR_ID = "originator_id_key";
    private static final String KEY_SEQUENCE = "sequence_key";
    private static final String KEY_SHOW = "show_key";
    private static final String VALUE_BUTTON = "button";
    private static final String VALUE_PUBLISH_TEXT = "publishText";
    private static final String VALUE_QUICK_REPLIES = "quickReplies";
    private static final String VALUE_ORIGINATOR_ID = "originatorId";
    private String welcomeMessage;
    private int numberOfItemsPerRow;
    private List<MessageOption> messageOptions;
    private MessageFrequency messageFrequency;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public LPWelcomeMessage createFromParcel(Parcel in) {
            return new LPWelcomeMessage(in);
        }

        public LPWelcomeMessage[] newArray(int size) {
            return new LPWelcomeMessage[size];
        }
    };

    public static boolean isQuickReplyActionsPresented(@Nullable String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return false;
        }
        try {
            JSONObject quickRepliesObject = new JSONObject(Objects.requireNonNull(json));
            JSONArray options = quickRepliesObject.optJSONArray(KEY_REPLIES);
            return options != null && options.length() > 0;
        }
        catch (Exception exception) {
            LPLog.INSTANCE.w(TAG, "getJsonString: error parsing quick reply json", exception);
            return false;
        }
    }

    public LPWelcomeMessage(String welcomeMessage) {
        this.welcomeMessage = welcomeMessage;
        this.numberOfItemsPerRow = 8;
        this.messageOptions = new ArrayList<MessageOption>();
        this.messageFrequency = MessageFrequency.FIRST_TIME_CONVERSATION;
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public boolean shouldUseDefaultMessage() {
        return TextUtils.isEmpty((CharSequence)this.welcomeMessage);
    }

    public void setNumberOfItemsPerRow(int numberOfItemsPerRow) {
        this.numberOfItemsPerRow = numberOfItemsPerRow;
    }

    public void setMessageOptions(@NonNull List<MessageOption> messageOptions) throws Exception {
        if (messageOptions.size() > 24) {
            String message = "Maximum number of quick replies is 24";
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000003F, message);
            throw new Exception(message);
        }
        for (MessageOption item : messageOptions) {
            if (item.getDisplayText().length() > 25) {
                String message = "Maximum number of characters is 25";
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000040, message);
                throw new Exception(message);
            }
            if (item.getDisplayText().trim().length() < 1) {
                String message = "Minimum number of characters is 1";
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000041, message);
                throw new Exception(message);
            }
            this.messageOptions.add(item);
            if (this.messageOptions.size() != 24) continue;
            return;
        }
    }

    public void setMessageFrequency(MessageFrequency messageFrequency) {
        this.messageFrequency = messageFrequency;
    }

    public MessageFrequency getMessageFrequency() {
        return this.messageFrequency;
    }

    public String getQuickReplies(boolean buttonClickable) {
        try {
            JSONArray repliesJsonArray = new JSONArray();
            for (MessageOption item : this.messageOptions) {
                JSONObject itemJsonObject = new JSONObject();
                itemJsonObject.put(KEY_TYPE, (Object)VALUE_BUTTON);
                itemJsonObject.put(KEY_TOOLTIP, (Object)item.getDisplayText());
                itemJsonObject.put(KEY_TITLE, (Object)item.getDisplayText());
                JSONObject clickJsonObject = new JSONObject();
                if (buttonClickable) {
                    JSONArray actionJsonArray = new JSONArray();
                    JSONObject actionJsonObject = new JSONObject();
                    actionJsonObject.put(KEY_TYPE, (Object)VALUE_PUBLISH_TEXT);
                    actionJsonObject.put(KEY_TEXT, (Object)item.getValue());
                    actionJsonArray.put((Object)actionJsonObject);
                    clickJsonObject.put(KEY_ACTIONS, (Object)actionJsonArray);
                    if (item.getMetadata() != null) {
                        clickJsonObject.put(KEY_METADATA, (Object)item.getMetadata());
                    }
                }
                itemJsonObject.put(KEY_CLICK, (Object)clickJsonObject);
                repliesJsonArray.put((Object)itemJsonObject);
            }
            JSONObject quickRepliesJsonObject = new JSONObject();
            quickRepliesJsonObject.put(KEY_TYPE, (Object)VALUE_QUICK_REPLIES);
            quickRepliesJsonObject.put(KEY_ITEMS_PER_ROW, this.numberOfItemsPerRow);
            quickRepliesJsonObject.put(KEY_REPLIES, (Object)repliesJsonArray);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(KEY_QUICK_REPLIES, (Object)quickRepliesJsonObject);
            jsonObject.put(KEY_TIME_STAMP, System.currentTimeMillis());
            jsonObject.put(KEY_ORIGINATOR_ID, (Object)VALUE_ORIGINATOR_ID);
            jsonObject.put(KEY_SEQUENCE, -4);
            jsonObject.put(KEY_SHOW, true);
            return DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, jsonObject.toString());
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000042, "Error when parsing json for welcome message quick replies", e);
            return "";
        }
    }

    private LPWelcomeMessage(Parcel in) {
        this.welcomeMessage = in.readString();
        this.numberOfItemsPerRow = in.readInt();
        if (this.messageOptions == null) {
            this.messageOptions = new ArrayList<MessageOption>();
        } else {
            this.messageOptions.clear();
        }
        in.readList(this.messageOptions, LPWelcomeMessage.class.getClassLoader());
        this.messageFrequency = MessageFrequency.values()[in.readInt()];
    }

    public int describeContents() {
        return 0;
    }

    public List<MessageOption> getMessageOptions() {
        return Collections.unmodifiableList(this.messageOptions);
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.welcomeMessage);
        dest.writeInt(this.numberOfItemsPerRow);
        dest.writeList(this.messageOptions);
        dest.writeInt(this.messageFrequency.ordinal());
    }

    public static enum MessageFrequency {
        FIRST_TIME_CONVERSATION,
        EVERY_CONVERSATION;


        public static MessageFrequency fromOrdinal(int ordinal) {
            return MessageFrequency.values()[ordinal];
        }
    }
}

