/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.IdRes;
import androidx.core.content.FileProvider;
import com.liveperson.infra.Infra;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00172\b\u0010-\u001a\u0004\u0018\u00010.H\u0007J\u001e\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u0001022\b\b\u0001\u00103\u001a\u00020\u0012H\u0007R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0003\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u00128FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\b*\u00020\u00178FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u001d*\u00020\u001e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001e\u0010#\u001a\u00020\u0012*\u00020\u001e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010 \u001a\u0004\b%\u0010&R\u001e\u0010'\u001a\u00020\u0012*\u00020\u001e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b(\u0010 \u001a\u0004\b)\u0010&\u00a8\u00064"}, d2={"Lcom/liveperson/infra/utils/AndroidFrameworkUtils;", "", "()V", "isDebug", "", "isDebug$annotations", "()Z", "manufacturer", "", "getManufacturer$annotations", "getManufacturer", "()Ljava/lang/String;", "resources", "Landroid/content/res/Resources;", "getResources$annotations", "getResources", "()Landroid/content/res/Resources;", "sdkVersion", "", "getSdkVersion$annotations", "getSdkVersion", "()I", "appVersion", "Landroid/content/Context;", "getAppVersion$annotations", "(Landroid/content/Context;)V", "getAppVersion", "(Landroid/content/Context;)Ljava/lang/String;", "displayMetrics", "Landroid/util/DisplayMetrics;", "Landroid/view/WindowManager;", "getDisplayMetrics$annotations", "(Landroid/view/WindowManager;)V", "getDisplayMetrics", "(Landroid/view/WindowManager;)Landroid/util/DisplayMetrics;", "displayMetricsHeight", "getDisplayMetricsHeight$annotations", "getDisplayMetricsHeight", "(Landroid/view/WindowManager;)I", "displayMetricsWidth", "getDisplayMetricsWidth$annotations", "getDisplayMetricsWidth", "getUriForFile", "Landroid/net/Uri;", "context", "lp_images_folder", "Ljava/io/File;", "obtainStyledAttributesByResID", "Landroid/content/res/TypedArray;", "activity", "Landroid/app/Activity;", "resId", "infra_release"})
public final class AndroidFrameworkUtils {
    @NotNull
    public static final AndroidFrameworkUtils INSTANCE = new AndroidFrameworkUtils();

    private AndroidFrameworkUtils() {
    }

    @NotNull
    public static final String getManufacturer() {
        String string = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MANUFACTURER");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getManufacturer$annotations() {
    }

    public static final int getSdkVersion() {
        return Build.VERSION.SDK_INT;
    }

    @JvmStatic
    public static /* synthetic */ void getSdkVersion$annotations() {
    }

    public static final boolean isDebug() {
        return false;
    }

    @JvmStatic
    public static /* synthetic */ void isDebug$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final Uri getUriForFile(@NotNull Context context, @Nullable File lp_images_folder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri uri = FileProvider.getUriForFile((Context)context, (String)(Infra.getFileProviderAuthorityPrefix() + context.getPackageName()), (File)File.createTempFile("image", ".jpg", lp_images_folder));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getUriForFile(\n         \u2026_images_folder)\n        )");
        return uri;
    }

    @NotNull
    public static final DisplayMetrics getDisplayMetrics(@NotNull WindowManager $this$displayMetrics) {
        DisplayMetrics displayMetrics;
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$displayMetrics, (String)"<this>");
            displayMetrics = new DisplayMetrics();
            Display display = $this$displayMetrics.getDefaultDisplay();
            if (display == null) break block0;
            display.getMetrics(displayMetrics);
        }
        return displayMetrics;
    }

    @JvmStatic
    public static /* synthetic */ void getDisplayMetrics$annotations(WindowManager windowManager) {
    }

    public static final int getDisplayMetricsHeight(@NotNull WindowManager $this$displayMetricsHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$displayMetricsHeight, (String)"<this>");
        return AndroidFrameworkUtils.getDisplayMetrics((WindowManager)$this$displayMetricsHeight).heightPixels;
    }

    @JvmStatic
    public static /* synthetic */ void getDisplayMetricsHeight$annotations(WindowManager windowManager) {
    }

    public static final int getDisplayMetricsWidth(@NotNull WindowManager $this$displayMetricsWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$displayMetricsWidth, (String)"<this>");
        return AndroidFrameworkUtils.getDisplayMetrics((WindowManager)$this$displayMetricsWidth).widthPixels;
    }

    @JvmStatic
    public static /* synthetic */ void getDisplayMetricsWidth$annotations(WindowManager windowManager) {
    }

    @JvmStatic
    @Nullable
    public static final TypedArray obtainStyledAttributesByResID(@Nullable Activity activity, @IdRes int resId) {
        TypedArray typedArray;
        Activity activity2 = activity;
        if (activity2 != null && (activity2 = activity2.getTheme()) != null) {
            int[] nArray = new int[]{resId};
            typedArray = activity2.obtainStyledAttributes(nArray);
        } else {
            typedArray = null;
        }
        return typedArray;
    }

    @NotNull
    public static final String getAppVersion(@NotNull Context $this$appVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$appVersion, (String)"<this>");
        String string = $this$appVersion.getPackageManager().getPackageInfo((String)$this$appVersion.getPackageName(), (int)0).versionName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageManager.getPackag\u2026ckageName, 0).versionName");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getAppVersion$annotations(Context context) {
    }

    @NotNull
    public static final Resources getResources() {
        Resources resources = Infra.instance.getApplicationContext().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"instance.applicationContext.resources");
        return resources;
    }

    @JvmStatic
    public static /* synthetic */ void getResources$annotations() {
    }
}

