package com.liveperson.infra.database;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.DispatchQueue;

/**
 * Created by Ilya Gazman on 9/9/2015.
 *
 * This class handling the execution of database tasks
 */
public class DataBaseExecutor {

    private static final String TAG = "DataBaseExecutor";

    private static DispatchQueue mDispatchQueue;
    private static boolean isIdle;
    private static ICallback<Void, Exception> mShutDownCallback;

    private static void init() {
        if (mDispatchQueue == null){
            mShutDownCallback = null;
            mDispatchQueue = new DispatchQueue("DataBase", () -> {
                isIdle = true;
                if (mShutDownCallback != null) {
                    shutDown(mShutDownCallback);
                    mShutDownCallback = null;
                }
            });
        }
    }

    /**
     * Will execute on database thread or will run on the current thread if you already on database thread
     */
    public static void execute(Runnable runnable) {
        init();
        isIdle = false;
        if (!mDispatchQueue.isCurrentThread()) {
            mDispatchQueue.postRunnable(runnable);
        } else {
            runnable.run();
        }
    }

    public static void killAll(final ICallback<Void, Exception> callback) {
        if(mDispatchQueue != null && mDispatchQueue.isAlive()){
            LPLog.INSTANCE.d(TAG, "killing all...");
            mDispatchQueue.cleanupQueue();
            if(isIdle){
                shutDown(callback);
            }else{
                mShutDownCallback = callback;
            }
        }
    }

    private static void shutDown(ICallback<Void, Exception> callback) {
        mDispatchQueue.dispose();
        mDispatchQueue = null;
        LPLog.INSTANCE.d(TAG, "kill all finished");
        callback.onSuccess(null);
    }
}
