package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

import com.liveperson.infra.log.LPLog;

/**
 * Created by ofira on 24/07/2015.
 */
public class ConversationsTable implements BaseTable {

    private static final String TAG = "ConversationsTable";

    //Conversation table name
    public static final String TABLE_NAME = "conversations";

    /**
     * Conversations table columns
     */
    public class Key {
        public static final String BRAND_ID = "brand_id";
        public static final String TARGET_ID = "target_id";

        public static final String START_TIMESTAMP = "start_timestamp";
        public static final String END_TIMESTAMP = "end_timestamp";
        public static final String STATE = "state";

        public static final String CLOSE_REASON = "close_reason";
        public static final String UNREAD_MESSAGES_COUNT = "unread_msg_count";
        public static final String REQUEST_ID = "request_id";

        public static final String CSAT_STATUS = "csat_status";
        public static final String TTR_TYPE = "ttr_type";
        public static final String CONVERSATION_ID = "conversation_id";

        public static final String CONCURRENT_REQUESTS_COUNTER = "concurrent_requests_counter";
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public String getCreateCommand() {
        return "create table " + TABLE_NAME + "(" +
                KEY_ID + " integer primary key autoincrement," +
                Key.CONVERSATION_ID + " text unique," +
                Key.BRAND_ID + " text," +
                Key.TARGET_ID + " text," +
                Key.UNREAD_MESSAGES_COUNT + " integer default -1," +
                Key.START_TIMESTAMP + " big int not null," +
                Key.REQUEST_ID + " big int," +
                Key.TTR_TYPE + " integer," +
                Key.CSAT_STATUS + " long default -1," +
                Key.END_TIMESTAMP + " long default -1," +
                Key.CLOSE_REASON + " integer default -1," +
                Key.CONCURRENT_REQUESTS_COUNTER + " integer default 0," +
                Key.STATE + " integer," +
                " UNIQUE ( " + Key.CONVERSATION_ID + ") ON CONFLICT IGNORE" +
                ");";
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 6) {
            LPLog.INSTANCE.d(TAG, "**** Migrating from old DB version (" + oldVersion + ") to new DB version (" + newVersion + ") ****");
            // Keeping the older versions migration steps
            String tempConversationsTableName = "conversationsOld";
            db.execSQL("ALTER TABLE " + TABLE_NAME + " RENAME TO " + tempConversationsTableName);

            // Create the updated conversations table
            db.execSQL(getCreateCommand());

            // First copy the necessary values to the new Conversations table
            String replaceConversationsTable = "insert into " + TABLE_NAME +
                    " (" + Key.CONVERSATION_ID +
                    ", " + Key.BRAND_ID +
                    ", " + Key.TARGET_ID +
                    ", " + Key.UNREAD_MESSAGES_COUNT +
                    ", " + Key.START_TIMESTAMP +
                    ", " + Key.END_TIMESTAMP +
                    ", " + Key.REQUEST_ID +
                    ", " + Key.TTR_TYPE +
                    ", " + Key.CSAT_STATUS +
                    ", " + Key.CLOSE_REASON +
                    ", " + Key.CONCURRENT_REQUESTS_COUNTER +
                    ", " + Key.STATE + ") " +
                    "select conversationId" +
                    ", brandId" +
                    ", targetId" +
                    ", unread_msg" +
                    ", start_time" +
                    ", close_time" +
                    ", " + Key.REQUEST_ID +
                    ", " + Key.TTR_TYPE +
                    ", showed_csat" +
                    ", " + Key.CLOSE_REASON +
                    ", updating_in_progress_semaphore" +
                    ", " + Key.STATE +
                    " from " + tempConversationsTableName;

            db.execSQL(replaceConversationsTable);


            db.execSQL(new DialogsTable().getCreateCommand());

            // Now copy the necessary values to the Dialogs table
            String updateDialogsTable = "insert into " + DialogsTable.TABLE_NAME +
                    " (" + DialogsTable.Key.CONVERSATION_ID +
                    // Migrating with a default value, the conversation + the dialog have same ID
                    ", " + DialogsTable.Key.DIALOG_ID +
                    ", " + DialogsTable.Key.DIALOG_TYPE +
                    ", " + DialogsTable.Key.CHANNEL_TYPE +
                    ", " + DialogsTable.Key.BRAND_ID +
                    ", " + DialogsTable.Key.TARGET_ID +
                    ", " + DialogsTable.Key.ASSIGNED_AGENT_ID +
                    ", " + DialogsTable.Key.LAST_SERVER_SEQUENCE +
                    ", " + DialogsTable.Key.UNREAD_MESSAGES_COUNT +
                    ", " + DialogsTable.Key.START_TIMESTAMP +
                    ", " + DialogsTable.Key.END_TIMESTAMP +
                    ", " + DialogsTable.Key.REQUEST_ID +
                    ", " + DialogsTable.Key.TTR_TYPE +
                    ", " + DialogsTable.Key.CSAT_STATUS +
                    ", " + DialogsTable.Key.CLOSE_REASON +
                    ", " + DialogsTable.Key.STATE +
                    ", " + DialogsTable.Key.CONCURRENT_REQUESTS_COUNTER + ") " +
                    "select conversationId" +
                    // Migrating with a default value, the conversation + the dialog have same ID
                    ", conversationId" +
                    ", 'MAIN' as " + DialogsTable.Key.DIALOG_TYPE +
                    ", 'MESSAGING' as " + DialogsTable.Key.CHANNEL_TYPE +
                    ", brandId" +
                    ", targetId" +
                    ", assignedAgentId" +
                    ", " + DialogsTable.Key.LAST_SERVER_SEQUENCE +
                    ", unread_msg" +
                    ", start_time" +
                    ", close_time" +
                    ", " + DialogsTable.Key.REQUEST_ID +
                    ", " + DialogsTable.Key.TTR_TYPE +
                    ", showed_csat" +
                    ", " + DialogsTable.Key.CLOSE_REASON +
                    ", " + DialogsTable.Key.STATE +
                    ", updating_in_progress_semaphore" +
                    " from " + tempConversationsTableName;

            db.execSQL(updateDialogsTable);

            // Remove temporary table
            db.execSQL("DROP TABLE " + tempConversationsTableName);
        }
    }
}
