package com.liveperson.infra.utils;

import android.content.res.Resources;
import android.text.TextUtils;

import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPLog;

import okio.ByteString;

/**
 * Created by ofira on 12/10/17.
 */
public class Utils {

    private static final String TAG = "Utils";
    public static final String SHA256 = "sha256/";
    public static final String SHA1 = "sha1/";

    public static boolean isValidCertificateKey(String key){
		ByteString hash;

        //Checking if the key is empty
        if(TextUtils.isEmpty(key)){
            LPLog.INSTANCE.d(TAG, "Certificate key is empty");
            return false;
        }

        //Checking if the key starts with 'sha256/' or 'sha1/'
		if (key.startsWith(SHA1)) {
			hash = ByteString.decodeBase64(key.substring("sha1/".length()));
		}
		else if (key.startsWith(SHA256)) {
			hash = ByteString.decodeBase64(key.substring("sha256/".length()));
		}
		else{
			LPLog.INSTANCE.w(TAG, "Key must start with 'sha256/' or 'sha1/'");
			return false;
		}

		if (hash == null) {
			LPLog.INSTANCE.w(TAG, "isValidCertificateKey: key must be base64");
			return false;
		}

		return true;
    }

    public static float tryParse(Object numberAsObject, float defaultValue) {
        if (numberAsObject == null) return defaultValue;

        float intValue = defaultValue;
        try {
            intValue = Float.valueOf(numberAsObject.toString());
        } catch (NumberFormatException e) {
            LPLog.INSTANCE.e(TAG, "Exception parsing " + numberAsObject, e);
        }

        return intValue;
    }

    public static int tryParse(Object numberAsObject, int defaultValue) {
        if (numberAsObject == null) return defaultValue;

        int intValue = defaultValue;
        try {
            intValue = Integer.valueOf(numberAsObject.toString());
        } catch (NumberFormatException e) {
            LPLog.INSTANCE.e(TAG, "Exception parsing " + numberAsObject, e);
        }

        return intValue;
    }

    public static Resources getResources() {
        return Infra.instance.getApplicationContext().getResources();
    }

    // https://stackoverflow.com/questions/140131/convert-a-string-representation-of-a-hex-dump-to-a-byte-array-using-java
    public static byte[] hexStringToByteArray(String string) {
        int len = string.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte) ((Character.digit(string.charAt(i), 16) << 4)
                    + Character.digit(string.charAt(i+1), 16));
        }
        return data;
    }
}
