/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.R;
import com.liveperson.infra.callbacks.InitLivePersonCallBack;
import com.liveperson.infra.callbacks.LogoutLivePersonCallBack;
import com.liveperson.infra.configuration.LptagEnvironment;
import com.liveperson.infra.controller.DBEncryptionKeyHelper;
import com.liveperson.infra.database.DatabaseManager;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.loggos.Loggos;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.sdkstatemachine.InfraStateMachine;
import com.liveperson.infra.sdkstatemachine.init.InfraInitData;
import com.liveperson.infra.sdkstatemachine.logout.PreLogoutCompletionListener;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownCompletionListener;
import com.liveperson.infra.statemachine.InitProcess;
import com.liveperson.infra.statemachine.LogoutProcess;
import com.liveperson.infra.statemachine.ShutDownProcess;
import com.liveperson.infra.statemachine.StateMachineExecutor;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.infra.utils.ThreadPoolExecutor;

public enum Infra implements Clearable
{
    instance;

    private static final String TAG = "Infra";
    public static final String KEY_BRAND_ID = "brand_id";
    public static final String KEY_AUTH_KEY = "auth_key";
    public static final String KEY_READ_ONLY = "read_only";
    public static final String KEY_VIEW_PARAMS = "view_params";
    public static final String SDK_VERSION = "SDK_VERSION";
    private static final String FILE_PROVIDER_AUTHORITY_PREFIX = "com.liveperson.infra.provider.";
    private InternetConnectionService mConnectionService;
    private Context mAppContext;
    private Handler mAppHandler = new Handler(Looper.getMainLooper());
    private DBEncryptionKeyHelper dbEncryptionKeyHelper;
    private String mHostVersion;
    private Loggos mLoggos;
    private LptagEnvironment mLptagEnvironment;
    InfraStateMachine stateMachine = null;

    private Infra() {
        this.initStateMachine();
    }

    public void init(Context context, InfraInitData initData, InitProcess entryPoint) {
        InfraInitProcess infraInit = new InfraInitProcess(context, initData, entryPoint);
        boolean interceptorsEnabled = context.getResources().getBoolean(R.bool.lp_interceptors_enabled);
        LPLog.INSTANCE.d(TAG, "init: Interceptors enabled: " + interceptorsEnabled);
        if (interceptorsEnabled && initData.getInterceptors() != null) {
            HttpHandler.addInterceptors(initData.getInterceptors().getHttpInterceptorList());
        }
        this.stateMachine.initSDK(infraInit);
    }

    private void initStateMachine() {
        if (this.stateMachine == null) {
            this.stateMachine = new InfraStateMachine();
            this.stateMachine.setStateMachineExecutor(new StateMachineExecutor(this.stateMachine.getTag(), this.stateMachine));
        }
    }

    private void initSDKVersion(String sdkVersion) {
        if (TextUtils.isEmpty((CharSequence)sdkVersion)) {
            this.mHostVersion = PreferenceManager.getInstance().getStringValue(SDK_VERSION, "", "");
            if (TextUtils.isEmpty((CharSequence)this.mHostVersion)) {
                throw new IllegalStateException("must have a value for sdk-version!");
            }
        } else {
            this.mHostVersion = sdkVersion;
            PreferenceManager.getInstance().setStringValue(SDK_VERSION, "", this.mHostVersion);
        }
    }

    public boolean isInitialized() {
        return this.stateMachine != null && this.stateMachine.isSDKInitialized();
    }

    private void initInfra(Context context, InfraInitData initData) {
        this.setContext(context);
        this.initSDKVersion(initData != null ? initData.getSdkVersion() : null);
        this.mLoggos = new Loggos();
        this.mLptagEnvironment = new LptagEnvironment();
        if (this.dbEncryptionKeyHelper == null) {
            this.dbEncryptionKeyHelper = new DBEncryptionKeyHelper(null);
        }
        this.mConnectionService = new InternetConnectionService();
    }

    public void shutDown(ShutDownProcess shutDownProcess) {
        InfraShutDownProcess shutDownInfra = new InfraShutDownProcess(shutDownProcess);
        this.stateMachine.shutDownSDK(shutDownInfra);
    }

    private void infraShutDown() {
        ForegroundService.getInstance().shutDown();
        SocketManager.getInstance().shutDown();
        ThreadPoolExecutor.killAll();
        DatabaseManager.getInstance().shutDown();
        this.mConnectionService.shutDown();
        this.mAppHandler.removeCallbacksAndMessages(null);
        this.mHostVersion = null;
    }

    public Context getApplicationContext() {
        return this.mAppContext;
    }

    public void postOnMainThread(Runnable runnable) {
        if (this.mAppHandler != null) {
            this.mAppHandler.post(runnable);
        }
    }

    public Handler getApplicationHandler() {
        return this.mAppHandler;
    }

    @VisibleForTesting
    public void setApplicationHandler(Handler handler) {
        this.mAppHandler = handler;
    }

    public String getHostVersion() {
        return this.mHostVersion;
    }

    public void unregisterToNetworkChanges() {
        if (this.mConnectionService != null) {
            this.mConnectionService.unRegisteredReceiver();
        }
    }

    public void registerToNetworkChanges() {
        if (this.mConnectionService != null) {
            this.mConnectionService.registeredReceiver();
        }
    }

    @Override
    public void clear() {
        if (this.mAppContext != null) {
            PreferenceManager.getInstance().clearAll();
            DatabaseManager.getInstance().clear();
            this.dbEncryptionKeyHelper.clear();
            this.dbEncryptionKeyHelper = null;
        }
    }

    public DBEncryptionKeyHelper getDbEncryptionKeyHelper() {
        return this.dbEncryptionKeyHelper;
    }

    public Loggos getLoggos() {
        return this.mLoggos;
    }

    public LptagEnvironment getLptagEnvironment() {
        return this.mLptagEnvironment;
    }

    public void logout(Context context, InfraInitData initData, LogoutProcess logoutProcess) {
        InfraLogoutProcess infraLogoutProcess = new InfraLogoutProcess(context, initData, logoutProcess);
        this.stateMachine.logoutSDK(infraLogoutProcess);
    }

    public static String getFileProviderAuthorityPrefix() {
        return FILE_PROVIDER_AUTHORITY_PREFIX;
    }

    public void setContext(Context context) {
        if (context != null) {
            this.mAppContext = context.getApplicationContext();
        } else {
            LPLog.INSTANCE.e(TAG, "setContext: The context cannot be null!");
        }
    }

    private class InfraLogoutProcess
    extends LogoutProcess {
        private final Context context;
        private final LogoutProcess logoutProcess;
        private final InfraInitData initData;

        InfraLogoutProcess(Context context, InfraInitData initData, LogoutProcess logoutProcess) {
            this.context = context;
            this.logoutProcess = logoutProcess;
            this.initData = initData;
        }

        @Override
        public void initForLogout() {
            Infra.this.initInfra(this.context, this.initData);
            this.logoutProcess.initForLogout();
        }

        @Override
        public void preLogout(final PreLogoutCompletionListener listener) {
            this.logoutProcess.preLogout(new PreLogoutCompletionListener(){

                @Override
                public void preLogoutCompleted() {
                    listener.preLogoutCompleted();
                }

                @Override
                public void preLogoutFailed(Exception e) {
                    listener.preLogoutFailed(e);
                }
            });
        }

        @Override
        public void shutDownForLogout(final ShutDownCompletionListener listener) {
            this.logoutProcess.shutDownForLogout(new ShutDownCompletionListener(){

                @Override
                public void shutDownCompleted() {
                    LPLog.INSTANCE.d(Infra.TAG, "Shutting down for logout...");
                    Infra.this.infraShutDown();
                    listener.shutDownCompleted();
                }

                @Override
                public void shutDownFailed() {
                    listener.shutDownFailed();
                }
            });
        }

        @Override
        public void logout() {
            this.logoutProcess.logout();
            Infra.this.clear();
            LocaleUtils.getInstance().clearEngagementLanguageCode();
        }

        @Override
        public LogoutLivePersonCallBack getLogoutCallback() {
            return this.logoutProcess.getLogoutCallback();
        }
    }

    private class InfraShutDownProcess
    extends ShutDownProcess {
        private final ShutDownProcess shutDownProcess;

        InfraShutDownProcess(ShutDownProcess shutDownProcess) {
            this.shutDownProcess = shutDownProcess;
        }

        @Override
        public void shutDown(final ShutDownCompletionListener listener) {
            this.shutDownProcess.shutDown(new ShutDownCompletionListener(){

                @Override
                public void shutDownCompleted() {
                    LPLog.INSTANCE.d(Infra.TAG, "Shutting down...");
                    Infra.this.infraShutDown();
                    listener.shutDownCompleted();
                }

                @Override
                public void shutDownFailed() {
                    listener.shutDownFailed();
                }
            });
        }
    }

    private class InfraInitProcess
    extends InitProcess {
        private final Context context;
        private final InfraInitData initData;
        private final InitProcess entryPoint;

        InfraInitProcess(Context context, InfraInitData initData, InitProcess entryPoint) {
            this.context = context;
            this.initData = initData;
            this.entryPoint = entryPoint;
        }

        @Override
        public void init() {
            LPLog.INSTANCE.d(Infra.TAG, "Initializing!");
            Infra.this.initInfra(this.context, this.initData);
            this.entryPoint.init();
        }

        @Override
        public InitLivePersonCallBack getInitCallback() {
            return this.entryPoint.getInitCallback();
        }
    }
}

