/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.liveperson.infra.Interceptors;
import com.liveperson.infra.MonitoringInitParams;
import com.liveperson.infra.callbacks.InitLivePersonCallBack;

public class InitLivePersonProperties {
    private static final String TAG = "InitLivePersonProperties";
    private String mBrandId;
    private InitLivePersonCallBack mInitCallBack;
    private String mAppId;
    private MonitoringInitParams mMonitoringInitParams;
    @Nullable
    private Interceptors mInterceptors;

    public InitLivePersonProperties(String brandId, String appId, InitLivePersonCallBack initCallBack) {
        this.mBrandId = brandId;
        this.mInitCallBack = initCallBack;
        this.mAppId = appId;
        this.mMonitoringInitParams = null;
    }

    public InitLivePersonProperties(String brandId, String appId, MonitoringInitParams monitoringInitParams, InitLivePersonCallBack initCallBack) {
        this(brandId, appId, initCallBack);
        this.mMonitoringInitParams = monitoringInitParams;
    }

    public void addInterceptors(@Nullable Interceptors interceptors) {
        this.mInterceptors = interceptors;
    }

    public String getBrandId() {
        return this.mBrandId;
    }

    public InitLivePersonCallBack getInitCallBack() {
        return this.mInitCallBack;
    }

    public void setInitCallBack(InitLivePersonCallBack initCallBack) {
        this.mInitCallBack = initCallBack;
    }

    public String getAppId() {
        return this.mAppId;
    }

    public MonitoringInitParams getMonitoringInitParams() {
        return this.mMonitoringInitParams;
    }

    public static boolean isValid(InitLivePersonProperties initProperties) {
        return initProperties != null && !TextUtils.isEmpty((CharSequence)initProperties.getBrandId()) && !TextUtils.isEmpty((CharSequence)initProperties.getAppId());
    }

    public boolean isMonitoringParamsValid() {
        return this.mMonitoringInitParams != null && !TextUtils.isEmpty((CharSequence)this.getMonitoringInitParams().getAppInstallId());
    }

    @Nullable
    public Interceptors getInterceptors() {
        return this.mInterceptors;
    }
}

