/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.database.tables;

import android.database.sqlite.SQLiteDatabase;
import com.liveperson.infra.database.tables.BaseTable;
import com.liveperson.infra.database.tables.DialogsTable;
import com.liveperson.infra.log.LPLog;

public class ConversationsTable
implements BaseTable {
    private static final String TAG = "ConversationsTable";
    public static final String TABLE_NAME = "conversations";

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public String getCreateCommand() {
        return "create table conversations(_id integer primary key autoincrement,conversation_id text unique,brand_id text,target_id text,unread_msg_count integer default -1,start_timestamp big int not null,request_id big int,ttr_type integer,csat_status long default -1,end_timestamp long default -1,close_reason integer default -1,concurrent_requests_counter integer default 0,state integer, UNIQUE ( conversation_id) ON CONFLICT IGNORE);";
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 6) {
            LPLog.INSTANCE.d(TAG, "**** Migrating from old DB version (" + oldVersion + ") to new DB version (" + newVersion + ") ****");
            String tempConversationsTableName = "conversationsOld";
            db.execSQL("ALTER TABLE conversations RENAME TO " + tempConversationsTableName);
            db.execSQL(this.getCreateCommand());
            String replaceConversationsTable = "insert into conversations (conversation_id, brand_id, target_id, unread_msg_count, start_timestamp, end_timestamp, request_id, ttr_type, csat_status, close_reason, concurrent_requests_counter, state) select conversationId, brandId, targetId, unread_msg, start_time, close_time, request_id, ttr_type, showed_csat, close_reason, updating_in_progress_semaphore, state from " + tempConversationsTableName;
            db.execSQL(replaceConversationsTable);
            db.execSQL(new DialogsTable().getCreateCommand());
            String updateDialogsTable = "insert into dialogs (conversation_id, dialog_id, dialog_type, channel_type, brand_id, target_id, assigned_agent_id, last_server_sequence, unread_msg_count, start_timestamp, end_timestamp, request_id, ttr_type, csat_status, close_reason, state, concurrent_requests_counter) select conversationId, conversationId, 'MAIN' as dialog_type, 'MESSAGING' as channel_type, brandId, targetId, assignedAgentId, last_server_sequence, unread_msg, start_time, close_time, request_id, ttr_type, showed_csat, close_reason, state, updating_in_progress_semaphore from " + tempConversationsTableName;
            db.execSQL(updateDialogsTable);
            db.execSQL("DROP TABLE " + tempConversationsTableName);
        }
    }

    public class Key {
        public static final String BRAND_ID = "brand_id";
        public static final String TARGET_ID = "target_id";
        public static final String START_TIMESTAMP = "start_timestamp";
        public static final String END_TIMESTAMP = "end_timestamp";
        public static final String STATE = "state";
        public static final String CLOSE_REASON = "close_reason";
        public static final String UNREAD_MESSAGES_COUNT = "unread_msg_count";
        public static final String REQUEST_ID = "request_id";
        public static final String CSAT_STATUS = "csat_status";
        public static final String TTR_TYPE = "ttr_type";
        public static final String CONVERSATION_ID = "conversation_id";
        public static final String CONCURRENT_REQUESTS_COUNTER = "concurrent_requests_counter";
    }
}

