/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.log;

import android.text.format.DateFormat;
import com.liveperson.infra.log.LogLevel;
import com.liveperson.infra.utils.ExceptionUtils;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u001f\u001a\u00020\u0005H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/liveperson/infra/log/LogLine;", "", "level", "Lcom/liveperson/infra/log/LogLevel;", "tag", "", "message", "exception", "", "(Lcom/liveperson/infra/log/LogLevel;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", "getException", "()Ljava/lang/Throwable;", "getLevel", "()Lcom/liveperson/infra/log/LogLevel;", "getMessage", "()Ljava/lang/String;", "getTag", "time", "", "getTime", "()J", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "infra_release"})
public final class LogLine {
    private final long time;
    @NotNull
    private final LogLevel level;
    @NotNull
    private final String tag;
    @NotNull
    private final String message;
    @Nullable
    private final Throwable exception;
    private static final String DATE_FORMAT = "yyyy-MM-dd kk:mm:ss.SSS";
    public static final Companion Companion = new Companion(null);

    public final long getTime() {
        return this.time;
    }

    @NotNull
    public String toString() {
        CharSequence charSequence;
        String exceptionString = this.exception != null ? ExceptionUtils.INSTANCE.getStringStackTrace(this.exception) : "";
        try {
            charSequence = DateFormat.format((CharSequence)DATE_FORMAT, (long)this.time);
        }
        catch (NoClassDefFoundError _) {
            charSequence = new SimpleDateFormat(DATE_FORMAT, Locale.US).format(this.time);
        }
        CharSequence timeString = charSequence;
        return timeString + " [" + this.level.getAbbreviation() + "] [" + this.tag + "] " + this.message + exceptionString;
    }

    @NotNull
    public final LogLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final Throwable getException() {
        return this.exception;
    }

    public LogLine(@NotNull LogLevel level, @NotNull String tag, @NotNull String message, @Nullable Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.level = level;
        this.tag = tag;
        this.message = message;
        this.exception = exception;
        this.time = System.currentTimeMillis();
    }

    public /* synthetic */ LogLine(LogLevel logLevel, String string2, String string3, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            throwable = null;
        }
        this(logLevel, string2, string3, throwable);
    }

    @NotNull
    public final LogLevel component1() {
        return this.level;
    }

    @NotNull
    public final String component2() {
        return this.tag;
    }

    @NotNull
    public final String component3() {
        return this.message;
    }

    @Nullable
    public final Throwable component4() {
        return this.exception;
    }

    @NotNull
    public final LogLine copy(@NotNull LogLevel level, @NotNull String tag, @NotNull String message, @Nullable Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return new LogLine(level, tag, message, exception);
    }

    public static /* synthetic */ LogLine copy$default(LogLine logLine, LogLevel logLevel, String string2, String string3, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            logLevel = logLine.level;
        }
        if ((n & 2) != 0) {
            string2 = logLine.tag;
        }
        if ((n & 4) != 0) {
            string3 = logLine.message;
        }
        if ((n & 8) != 0) {
            throwable = logLine.exception;
        }
        return logLine.copy(logLevel, string2, string3, throwable);
    }

    public int hashCode() {
        LogLevel logLevel = this.level;
        String string2 = this.tag;
        String string3 = this.message;
        Throwable throwable = this.exception;
        return (((logLevel != null ? ((Object)((Object)logLevel)).hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (throwable != null ? throwable.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LogLine)) break block3;
                LogLine logLine = (LogLine)object;
                if (!Intrinsics.areEqual((Object)((Object)this.level), (Object)((Object)logLine.level)) || !Intrinsics.areEqual((Object)this.tag, (Object)logLine.tag) || !Intrinsics.areEqual((Object)this.message, (Object)logLine.message) || !Intrinsics.areEqual((Object)this.exception, (Object)logLine.exception)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/infra/log/LogLine$Companion;", "", "()V", "DATE_FORMAT", "", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

