/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.loggos;

import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.log.LogLine;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/liveperson/infra/loggos/LoggosMessageFactory;", "", "accountId", "", "(Ljava/lang/String;)V", "convertToJson", "Lorg/json/JSONObject;", "logLine", "Lcom/liveperson/infra/log/LogLine;", "Companion", "infra_release"})
public final class LoggosMessageFactory {
    private final String accountId;
    private static final String TAG = "LoggosMessage";
    private static final String LOGGOS_CONTEXT = "context";
    private static final String LOGGOS_ANDROID_CONTEXT = "AndroidSdk";
    private static final String SDK_VERSION = "integrationVersion";
    private static final String ACCOUNT_ID = "accountId";
    private static final String TIME = "time";
    private static final String FILENAME = "filename";
    private static final String LOG_LEVEL = "logLevel";
    private static final String TITLE = "title";
    private static final String MESSAGE = "msg";
    private static final String UUID = "uid";
    private static final String TIMESTAMP_FORMAT = "yyyy-mm-dd HH:MM:SS,SSS";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final JSONObject convertToJson(@NotNull LogLine logLine) {
        Intrinsics.checkParameterIsNotNull((Object)logLine, (String)"logLine");
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(LOGGOS_CONTEXT, (Object)LOGGOS_ANDROID_CONTEXT);
            jsonObject.put(SDK_VERSION, (Object)"5.2.0");
            jsonObject.put(ACCOUNT_ID, (Object)this.accountId);
            jsonObject.put(TIME, (Object)new SimpleDateFormat(TIMESTAMP_FORMAT, Locale.ENGLISH).format(logLine.getTime()));
            jsonObject.put(FILENAME, (Object)logLine.getTag());
            jsonObject.put(LOG_LEVEL, (Object)logLine.getLevel().getApiName());
            jsonObject.put(TITLE, (Object)logLine.getMessage());
            jsonObject.put(MESSAGE, (Object)logLine.toString());
            jsonObject.put(UUID, (Object)java.util.UUID.randomUUID().toString());
        }
        catch (JSONException e) {
            LPLog.INSTANCE.w(TAG, "Exception when serializing Logs to LoggosMessages", e);
        }
        return jsonObject;
    }

    public LoggosMessageFactory(@NotNull String accountId) {
        Intrinsics.checkParameterIsNotNull((Object)accountId, (String)ACCOUNT_ID);
        this.accountId = accountId;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/liveperson/infra/loggos/LoggosMessageFactory$Companion;", "", "()V", "ACCOUNT_ID", "", "FILENAME", "LOGGOS_ANDROID_CONTEXT", "LOGGOS_CONTEXT", "LOG_LEVEL", "MESSAGE", "SDK_VERSION", "TAG", "TIME", "TIMESTAMP_FORMAT", "TITLE", "UUID", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

