/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import androidx.annotation.Nullable;
import com.liveperson.infra.log.LPLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtils {
    private static final String TAG = "FileUtils";
    private static final String IMAGES_FOLDER = "images/";
    private static final String VOICE_FOLDER = "voice/";
    private static final String DOCUMENTS_FOLDER = "documents/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileContent(Context context, File privateDirectory, Uri publicDirectory) {
        FileInputStream inputStream = null;
        ParcelFileDescriptor parcelFileDescriptor = null;
        FileOutputStream fileOutputStream = null;
        try {
            int len;
            inputStream = new FileInputStream(privateDirectory);
            parcelFileDescriptor = context.getContentResolver().openFileDescriptor(publicDirectory, "w");
            fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
            byte[] b = new byte[5120];
            while ((len = inputStream.read(b)) > 0) {
                fileOutputStream.write(b, 0, len);
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, "Failed to copy file from privateDir to publicDir. ", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (parcelFileDescriptor != null) {
                    parcelFileDescriptor.close();
                }
            }
            catch (IOException exception) {
                LPLog.INSTANCE.e(TAG, "Failed to close fileOutputStream/parcelFileDescriptor ", exception);
            }
        }
        return true;
    }

    @Nullable
    public static File getFilePath(Context context, String path, String filename) {
        File privateDir = new File(context.getApplicationContext().getFilesDir() + path);
        File filePath = new File(privateDir, filename);
        if (!privateDir.exists() && !privateDir.mkdirs()) {
            LPLog.INSTANCE.e(TAG, "getFilePath: folder could not be created");
            return null;
        }
        return filePath;
    }

    public static void deleteAllSharedFiles(Context context) {
        LPLog.INSTANCE.d(TAG, "deleting all shared files with agent");
        FileUtils.deleteFolder(context, IMAGES_FOLDER);
        FileUtils.deleteFolder(context, VOICE_FOLDER);
        FileUtils.deleteFolder(context, DOCUMENTS_FOLDER);
    }

    private static void deleteFolder(Context context, String folderName) {
        File dirToDelete = new File(context.getFilesDir() + "/" + folderName + "/");
        LPLog.INSTANCE.d(TAG, "delete" + folderName + "Folder: Trying to delete the" + folderName + "folder:" + dirToDelete.getAbsolutePath());
        FileUtils.deleteRecursively(dirToDelete);
    }

    private static void deleteRecursively(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            LPLog.INSTANCE.d(TAG, "deleteRecursive: deleting directory: " + fileOrDirectory.getAbsolutePath());
            for (File child : fileOrDirectory.listFiles()) {
                LPLog.INSTANCE.d(TAG, "deleteRecursive: deleting file: " + child.getAbsolutePath());
                FileUtils.deleteRecursively(child);
            }
        }
        fileOrDirectory.delete();
    }
}

