/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.controller;

import com.liveperson.infra.controller.AudioPlayable;
import com.liveperson.infra.log.LPLog;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/liveperson/infra/controller/PlayingAudioManager;", "", "()V", "mCurrentlyPlayingList", "", "Lcom/liveperson/infra/controller/AudioPlayable;", "getMCurrentlyPlayingList", "()Ljava/util/Set;", "addPlaying", "", "audioPlayable", "addPlayingAndStopOthers", "removePlaying", "stopAllCurrentlyPlaying", "stopPlaying", "toString", "", "Companion", "infra_release"})
public final class PlayingAudioManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<AudioPlayable> mCurrentlyPlayingList = new HashSet();
    @NotNull
    private static final String TAG = "PlayingAudioManager";

    @NotNull
    public final Set<AudioPlayable> getMCurrentlyPlayingList() {
        return this.mCurrentlyPlayingList;
    }

    private final void addPlaying(AudioPlayable audioPlayable) {
        LPLog.INSTANCE.d(TAG, "addPlaying: adding " + audioPlayable);
        this.mCurrentlyPlayingList.add(audioPlayable);
        LPLog.INSTANCE.d(TAG, this.toString());
    }

    public final void addPlayingAndStopOthers(@NotNull AudioPlayable audioPlayable) {
        Intrinsics.checkNotNullParameter((Object)audioPlayable, (String)"audioPlayable");
        LPLog.INSTANCE.d(TAG, "addPlayingAndStopOthers: adding " + audioPlayable);
        this.stopAllCurrentlyPlaying();
        this.addPlaying(audioPlayable);
    }

    public final void removePlaying(@NotNull AudioPlayable audioPlayable) {
        Intrinsics.checkNotNullParameter((Object)audioPlayable, (String)"audioPlayable");
        LPLog.INSTANCE.d(TAG, "removePlaying: removing " + audioPlayable);
        this.mCurrentlyPlayingList.remove(audioPlayable);
        LPLog.INSTANCE.d(TAG, this.toString());
    }

    public final void stopPlaying(@NotNull AudioPlayable audioPlayable) {
        Intrinsics.checkNotNullParameter((Object)audioPlayable, (String)"audioPlayable");
        LPLog.INSTANCE.d(TAG, "stopPlaying: stopping and removing " + audioPlayable);
        audioPlayable.stopPlaying();
        this.removePlaying(audioPlayable);
    }

    public final void stopAllCurrentlyPlaying() {
        for (AudioPlayable audioPlayable : this.mCurrentlyPlayingList) {
            this.stopPlaying(audioPlayable);
        }
        LPLog.INSTANCE.d(TAG, this.toString());
    }

    @NotNull
    public String toString() {
        return "Currently in list " + this.mCurrentlyPlayingList.size() + " items. " + this.mCurrentlyPlayingList;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/infra/controller/PlayingAudioManager$Companion;", "", "()V", "TAG", "", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

