/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.Consumer;
import com.liveperson.infra.utils.EncryptionVersion;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\n\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\n\u001a\u0004\u0018\u00010\bJ\u001c\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u001a\u0010\u0014\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\bJ\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010J\u0012\u0010\u0018\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0007J\u001a\u0010\u001a\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/liveperson/infra/preferences/AuthPreferences;", "", "applicationContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "preferences", "Landroid/content/SharedPreferences;", "buildKey", "", "key", "brandId", "clearAll", "", "getAuthToken", "defaultValue", "getCachedConsumer", "Lcom/liveperson/infra/model/Consumer;", "getCurrentAuthType", "Lcom/liveperson/infra/auth/LPAuthenticationType;", "getUnAuthToken", "setAuthToken", "value", "setCachedConsumer", "consumer", "setPreferenceDelegate", "prefs", "setUnAuthToken", "Companion", "infra_release"})
public final class AuthPreferences {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SharedPreferences preferences;
    @NotNull
    private static final String TAG = "AuthPreferences";
    @NotNull
    private static final String LP_AUTH_SHARED_PREF_FILENAME = "lp_auth_shared_pref";
    @NotNull
    private static final String KEY_IDP_DOMAIN = "idp_domain";
    @NotNull
    private static final String OLD_KEY_IDP_DOMAIN = "idp";
    @NotNull
    private static final String KEY_ACCOUNT_UN_AUTH_TOKEN = "account_un_auth_token";
    @NotNull
    private static final String KEY_CONSUMER_ID = "consumer_id";
    @NotNull
    private static final String KEY_ORIGINAL_CONSUMER_ID = "original_consumer_id";
    @NotNull
    private static final String KEY_LP_TOKEN = "lp_token";
    @NotNull
    private static final String KEY_AUTH_TYPE = "auth_type";
    @NotNull
    private static final String KEY_CURRENT_AUTH_TYPE = "current_auth_type";
    @NotNull
    private static final String KEY_AUTH_KEY = "auth_key";
    @NotNull
    private static final String KEY_HOST_APP_JWT = "host_app_jwt";
    @NotNull
    private static final String KEY_HOST_APP_REDIRECT_URI = "host_app_redirect_uri";
    @NotNull
    private static final String KEY_PINNING_KEYS = "pinning_keys";
    @Nullable
    private static AuthPreferences instance;

    private AuthPreferences(Context applicationContext) {
        this.preferences = applicationContext.getSharedPreferences(LP_AUTH_SHARED_PREF_FILENAME, 0);
    }

    @VisibleForTesting
    public final void setPreferenceDelegate(@Nullable SharedPreferences prefs) {
        this.preferences = prefs;
    }

    public final void setUnAuthToken(@Nullable String brandId, @Nullable String value) {
        block0: {
            SharedPreferences.Editor editor;
            SharedPreferences.Editor editor2;
            SharedPreferences sharedPreferences = this.preferences;
            if (sharedPreferences == null || (editor2 = sharedPreferences.edit()) == null || (editor = editor2.putString(this.buildKey(KEY_ACCOUNT_UN_AUTH_TOKEN, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, value))) == null) break block0;
            editor.apply();
        }
    }

    @Nullable
    public final String getUnAuthToken(@Nullable String brandId, @Nullable String defaultValue) {
        SharedPreferences sharedPreferences = this.preferences;
        return DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences != null ? sharedPreferences.getString(this.buildKey(KEY_ACCOUNT_UN_AUTH_TOKEN, brandId), defaultValue) : null);
    }

    public final void setAuthToken(@Nullable String brandId, @Nullable String value) {
        block0: {
            SharedPreferences.Editor editor;
            SharedPreferences.Editor editor2;
            SharedPreferences sharedPreferences = this.preferences;
            if (sharedPreferences == null || (editor2 = sharedPreferences.edit()) == null || (editor = editor2.putString(this.buildKey(KEY_LP_TOKEN, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, value))) == null) break block0;
            editor.apply();
        }
    }

    @Nullable
    public final String getAuthToken(@Nullable String brandId, @Nullable String defaultValue) {
        SharedPreferences sharedPreferences = this.preferences;
        return DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences != null ? sharedPreferences.getString(this.buildKey(KEY_LP_TOKEN, brandId), defaultValue) : null);
    }

    @Nullable
    public final LPAuthenticationType getCurrentAuthType(@Nullable String brandId) {
        SharedPreferences sharedPreferences = this.preferences;
        return LPAuthenticationType.Companion.fromStorageVal(sharedPreferences != null ? sharedPreferences.getInt(this.buildKey(KEY_CURRENT_AUTH_TYPE, brandId), LPAuthenticationType.SIGN_UP.getStorageVal()) : LPAuthenticationType.SIGN_UP.getStorageVal());
    }

    public final void setCachedConsumer(@NotNull String brandId, @Nullable Consumer consumer) {
        block8: {
            SharedPreferences.Editor editor;
            Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
            SharedPreferences sharedPreferences = this.preferences;
            Object object = editor = sharedPreferences != null ? sharedPreferences.edit() : null;
            if (consumer == null) {
                SharedPreferences.Editor editor2;
                SharedPreferences.Editor editor3;
                SharedPreferences.Editor editor4;
                SharedPreferences.Editor editor5;
                SharedPreferences.Editor editor6;
                SharedPreferences.Editor editor7;
                SharedPreferences.Editor editor8;
                if (editor != null && (editor8 = editor.remove(this.buildKey(KEY_CONSUMER_ID, brandId))) != null && (editor7 = editor8.remove(this.buildKey(KEY_ORIGINAL_CONSUMER_ID, brandId))) != null && (editor6 = editor7.remove(this.buildKey(KEY_LP_TOKEN, brandId))) != null && (editor5 = editor6.remove(this.buildKey(KEY_AUTH_TYPE, brandId))) != null && (editor4 = editor5.remove(this.buildKey(KEY_AUTH_KEY, brandId))) != null && (editor3 = editor4.remove(this.buildKey(KEY_HOST_APP_JWT, brandId))) != null && (editor2 = editor3.remove(this.buildKey(KEY_HOST_APP_REDIRECT_URI, brandId))) != null) {
                    editor2.remove(this.buildKey(KEY_PINNING_KEYS, brandId));
                }
            } else {
                SharedPreferences.Editor editor9;
                SharedPreferences.Editor editor10;
                if (editor != null && (editor10 = editor.putString(this.buildKey(KEY_CONSUMER_ID, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, consumer.getConsumerId()))) != null && (editor9 = editor10.putString(this.buildKey(KEY_ORIGINAL_CONSUMER_ID, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, consumer.getOriginalConsumerId()))) != null) {
                    editor9.putString(this.buildKey(KEY_LP_TOKEN, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, consumer.getLpToken()));
                }
                if (consumer.getLpAuthenticationParams() != null) {
                    SharedPreferences.Editor editor11;
                    SharedPreferences.Editor editor12;
                    if (editor != null && (editor10 = editor.putInt(this.buildKey(KEY_AUTH_TYPE, brandId), consumer.getLpAuthenticationParams().getAuthType().getStorageVal())) != null && (editor9 = editor10.putInt(this.buildKey(KEY_CURRENT_AUTH_TYPE, brandId), consumer.getLpAuthenticationParams().getAuthType().getStorageVal())) != null && (editor12 = editor9.putString(this.buildKey(KEY_AUTH_KEY, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, consumer.getLpAuthenticationParams().getAuthKey()))) != null && (editor11 = editor12.putString(this.buildKey(KEY_HOST_APP_JWT, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, consumer.getLpAuthenticationParams().getHostAppJWT()))) != null) {
                        editor11.putString(this.buildKey(KEY_HOST_APP_REDIRECT_URI, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, consumer.getLpAuthenticationParams().getHostAppRedirectUri()));
                    }
                    HashSet<String> keys = new HashSet<String>();
                    for (String key : consumer.getLpAuthenticationParams().getCertificatePinningKeys()) {
                        keys.add(DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, key));
                    }
                    SharedPreferences.Editor editor13 = editor;
                    if (editor13 != null) {
                        editor13.putStringSet(this.buildKey(KEY_PINNING_KEYS, brandId), (Set)keys);
                    }
                }
            }
            SharedPreferences.Editor editor14 = editor;
            if (editor14 == null) break block8;
            editor14.apply();
        }
    }

    @Nullable
    public final Consumer getCachedConsumer(@Nullable String brandId) {
        String key;
        Object object;
        CharSequence charSequence = brandId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        LPAuthenticationParams authParams = null;
        Consumer consumer = null;
        SharedPreferences sharedPreferences = this.preferences;
        boolean bl = sharedPreferences != null ? sharedPreferences.contains(this.buildKey(KEY_AUTH_TYPE, brandId)) : false;
        if (bl) {
            SharedPreferences sharedPreferences2 = this.preferences;
            LPAuthenticationType authType = LPAuthenticationType.Companion.fromStorageVal(sharedPreferences2 != null ? sharedPreferences2.getInt(this.buildKey(KEY_AUTH_TYPE, brandId), LPAuthenticationType.SIGN_UP.getStorageVal()) : LPAuthenticationType.SIGN_UP.getStorageVal());
            authParams = new LPAuthenticationParams(authType);
            SharedPreferences sharedPreferences3 = this.preferences;
            authParams.setAuthKey(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences3 != null ? sharedPreferences3.getString(this.buildKey(KEY_AUTH_KEY, brandId), "") : null));
            SharedPreferences sharedPreferences4 = this.preferences;
            authParams.setHostAppJWT(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences4 != null ? sharedPreferences4.getString(this.buildKey(KEY_HOST_APP_JWT, brandId), "") : null));
            SharedPreferences sharedPreferences5 = this.preferences;
            authParams.setHostAppRedirectUri(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences5 != null ? sharedPreferences5.getString(this.buildKey(KEY_HOST_APP_REDIRECT_URI, brandId), "") : null));
            Object object2 = this.preferences;
            if (object2 == null || (object2 = object2.getStringSet(this.buildKey(KEY_PINNING_KEYS, brandId), Collections.emptySet())) == null) {
                object2 = Collections.emptySet();
            }
            object = object2.iterator();
            while (object.hasNext()) {
                key = (String)object.next();
                authParams.addCertificatePinningKey(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, key));
            }
        }
        SharedPreferences sharedPreferences6 = this.preferences;
        object = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences6 != null ? sharedPreferences6.getString(this.buildKey(KEY_CONSUMER_ID, brandId), "") : null);
        String consumerId = object == null ? "" : object;
        SharedPreferences sharedPreferences7 = this.preferences;
        key = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences7 != null ? sharedPreferences7.getString(this.buildKey(KEY_ORIGINAL_CONSUMER_ID, brandId), "") : null);
        String originalConsumerId = key == null ? "" : key;
        SharedPreferences sharedPreferences8 = this.preferences;
        String string = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences8 != null ? sharedPreferences8.getString(this.buildKey(KEY_LP_TOKEN, brandId), "") : null);
        String lpToken = string == null ? "" : string;
        if (((CharSequence)consumerId).length() > 0 && ((CharSequence)lpToken).length() > 0) {
            consumer = new Consumer(authParams, brandId, consumerId, originalConsumerId, lpToken);
        } else {
            this.clearAll();
        }
        return consumer;
    }

    private final String buildKey(String key, String brandId) {
        return key + "$$" + brandId;
    }

    public final void clearAll() {
        block0: {
            LPLog.INSTANCE.d(TAG, "clearAll: Clearing all data of Auth preferences");
            SharedPreferences sharedPreferences = this.preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.clear()) == null) break block0;
            sharedPreferences.apply();
        }
    }

    public /* synthetic */ AuthPreferences(Context applicationContext, DefaultConstructorMarker $constructor_marker) {
        this(applicationContext);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/liveperson/infra/preferences/AuthPreferences$Companion;", "", "()V", "KEY_ACCOUNT_UN_AUTH_TOKEN", "", "KEY_AUTH_KEY", "KEY_AUTH_TYPE", "KEY_CONSUMER_ID", "KEY_CURRENT_AUTH_TYPE", "KEY_HOST_APP_JWT", "KEY_HOST_APP_REDIRECT_URI", "KEY_IDP_DOMAIN", "KEY_LP_TOKEN", "KEY_ORIGINAL_CONSUMER_ID", "KEY_PINNING_KEYS", "LP_AUTH_SHARED_PREF_FILENAME", "OLD_KEY_IDP_DOMAIN", "TAG", "instance", "Lcom/liveperson/infra/preferences/AuthPreferences;", "getInstance", "context", "Landroid/content/Context;", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AuthPreferences getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (instance == null) {
                instance = new AuthPreferences(context, null);
            }
            AuthPreferences authPreferences = instance;
            if (authPreferences == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.liveperson.infra.preferences.AuthPreferences");
            }
            return authPreferences;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

