/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/liveperson/infra/utils/TokenUtils;", "", "()V", "TAG", "", "getConsumerUserId", "jwt", "getOriginalConsumerIdFromJWT", "infra_release"})
public final class TokenUtils {
    @NotNull
    public static final TokenUtils INSTANCE = new TokenUtils();
    @NotNull
    private static final String TAG = "TokenUtils";

    private TokenUtils() {
    }

    @Nullable
    public final String getConsumerUserId(@Nullable String jwt) {
        String[] stringArray;
        String[] stringArray2;
        if (TextUtils.isEmpty((CharSequence)jwt)) {
            return "";
        }
        LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "getConsumerUserId: Getting original consumerId from jwt: " + LPLog.INSTANCE.mask(jwt));
        Object object = jwt;
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray2 = new String[]{"."}), (boolean)false, (int)0, (int)6, null)) != null) {
            Collection $this$toTypedArray$iv = (Collection)object;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray3, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            stringArray = stringArray3;
        } else {
            stringArray = null;
        }
        String[] segments = stringArray;
        Integer n = segments != null ? Integer.valueOf(segments.length) : null;
        Intrinsics.checkNotNull((Object)n);
        if (n < 3) {
            return "";
        }
        try {
            byte[] secondSegmentsByte = Base64.decode((String)segments[1], (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)secondSegmentsByte, (String)"secondSegmentsByte");
            byte[] $i$f$toTypedArray = secondSegmentsByte;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            String secondSegments = new String($i$f$toTypedArray, charset2);
            JSONObject secondSegmentsJson = new JSONObject(secondSegments);
            return secondSegmentsJson.optString("sub");
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000141, "getConsumerUserId: Exception while getting Consumer User ID.", e);
            return "";
        }
    }

    @Nullable
    public final String getOriginalConsumerIdFromJWT(@Nullable String jwt) {
        String[] stringArray;
        Object thisCollection$iv;
        String[] stringArray2;
        if (TextUtils.isEmpty((CharSequence)jwt)) {
            return "";
        }
        LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "Getting original consumerId from jwt: " + LPLog.INSTANCE.mask(jwt));
        Object object = jwt;
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray2 = new String[]{"."}), (boolean)false, (int)0, (int)6, null)) != null) {
            Collection $this$toTypedArray$iv = (Collection)object;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray3, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            stringArray = stringArray3;
        } else {
            stringArray = null;
        }
        String[] segments = stringArray;
        Integer n = segments != null ? Integer.valueOf(segments.length) : null;
        Intrinsics.checkNotNull((Object)n);
        if (n < 3) {
            return "";
        }
        try {
            byte[] secondSegmentsByte = Base64.decode((String)segments[1], (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)secondSegmentsByte, (String)"secondSegmentsByte");
            byte[] $i$f$toTypedArray = secondSegmentsByte;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            thisCollection$iv = charset;
            String secondSegments = new String($i$f$toTypedArray, (Charset)thisCollection$iv);
            JSONObject secondSegmentsJson = new JSONObject(secondSegments);
            JSONObject lpExt = secondSegmentsJson.optJSONObject("lp.ext");
            if (lpExt != null) {
                return lpExt.optString("sub");
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000BA, "Exception while getting original consumer ID from JWT.", e);
        }
        return "";
    }
}

