package com.liveperson.infra.network.http.requests;

import android.text.TextUtils;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.otel.LPTraceType;

import java.util.List;

import static com.liveperson.infra.errors.ErrorCode.ERR_0000004E;

/**
 * Created by nirni on 12/29/15.
 * <p/>
 * This is an HTTP request to the configuration server to get the supported version
 */
public class ConfigurationRequest implements Command {

    private static final String TAG = "ConfigurationRequest";
    private static final int CONFIGURATION_REQUEST_TIMEOUT = 30000;

    // The URL to get the version
    private static final String CONFIGURATION_URL = "https://%s/mobile/configuration/androidConfig.json";

    private String mConfigurationDomain;
    private ICallback<String, Exception> mCallback;
    private List<String> mCertificates;

    public ConfigurationRequest(String configurationDomain, List<String> certificates, ICallback<String, Exception> callback) {
        mConfigurationDomain = configurationDomain;
        mCertificates = certificates;
        mCallback = callback;
    }

    @Override
    public void execute() {

        String versionUrl = String.format(CONFIGURATION_URL, mConfigurationDomain);

        HttpGetRequest httpGetRequest = new HttpGetRequest(versionUrl,
                LPTraceType.LPCDN_SETTINGS_REQ);
        httpGetRequest.setTimeout(CONFIGURATION_REQUEST_TIMEOUT);
        httpGetRequest.setCertificatePinningKeys(mCertificates);
        httpGetRequest.setCallback(new ICallback<String, Exception>() {
            @Override
            public void onSuccess(String configurationStr) {
                if (!TextUtils.isEmpty(configurationStr)) {
                    LPLog.INSTANCE.d(TAG, "configurationRequest - onCompleted " + configurationStr);
                    mCallback.onSuccess(configurationStr);
                } else {
                    LPLog.INSTANCE.e(TAG, ERR_0000004E, "onSuccess: configuration string is empty");
                    mCallback.onError(new Exception("Configuration string is empty"));
                }
            }

            @Override
            public void onError(Exception e) {
                LPLog.INSTANCE.d(TAG, "Exception: ", e);
                mCallback.onError(e);
            }
        });
        HttpHandler.execute(httpGetRequest);
    }
}
