package com.liveperson.infra.utils;

import com.liveperson.infra.log.LPLog;

/**
 * Created by shiranr on 15/06/2016.
 */
public class MaskedMessage {

    private static final String TAG = "MaskedMessage";

    private String dbMessage;
    private String serverMessage;
    private String maskedSystemMessage;
    private boolean isMasked;

    public MaskedMessage(String dbMessage, String serverMessage, boolean masked, String maskedSystemMessage) {
        this.dbMessage = dbMessage;
        this.serverMessage = serverMessage;
        isMasked = masked;
        this.maskedSystemMessage = maskedSystemMessage;
        LPLog.INSTANCE.d(TAG, "dbMessage: "+ LPLog.INSTANCE.mask(dbMessage) + ", serverMessage: "+ LPLog.INSTANCE.mask(serverMessage) + ", isMasked: " + isMasked);
    }

    public String getDbMessage() {
        return dbMessage;
    }

    public String getServerMessage() {
        return serverMessage;
    }

    public boolean isMasked() {
        return isMasked;
    }

    public String getMaskedSystemMessage() {
        return maskedSystemMessage;
    }

    public void setDbMessage(String message) {
         dbMessage = message;
    }

    public void setServerMessage(String message) {
        serverMessage = message;
        LPLog.INSTANCE.w("MaskedMessage", "dbMessage------> "+ LPLog.INSTANCE.mask(dbMessage));
    }
}
