/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.otel.LPTraceType;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001BA\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\tj\u0002`\n0\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\tj\u0002`\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/liveperson/infra/network/http/requests/ACCDNConnectorsRequest;", "Lcom/liveperson/infra/Command;", "requestDomain", "", "brandId", "certificates", "", "callback", "Lcom/liveperson/infra/ICallback;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/liveperson/infra/ICallback;)V", "ACCDN_URL", "TAG", "getBrandId", "()Ljava/lang/String;", "getCallback", "()Lcom/liveperson/infra/ICallback;", "getCertificates", "()Ljava/util/List;", "execute", "", "responseContainsError", "", "value", "infra_release"})
public final class ACCDNConnectorsRequest
implements Command {
    @Nullable
    private final String requestDomain;
    @Nullable
    private final String brandId;
    @Nullable
    private final List<String> certificates;
    @NotNull
    private final ICallback<String, Exception> callback;
    @NotNull
    private final String TAG;
    @NotNull
    private final String ACCDN_URL;

    public ACCDNConnectorsRequest(@Nullable String requestDomain, @Nullable String brandId, @Nullable List<String> certificates, @NotNull ICallback<String, Exception> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.requestDomain = requestDomain;
        this.brandId = brandId;
        this.certificates = certificates;
        this.callback = callback2;
        this.TAG = "ACCDNConnectorsRequest";
        this.ACCDN_URL = "https://%s/api/account/%s/configuration/le-connectors/all-connectors";
    }

    @Nullable
    public final String getBrandId() {
        return this.brandId;
    }

    @Nullable
    public final List<String> getCertificates() {
        return this.certificates;
    }

    @NotNull
    public final ICallback<String, Exception> getCallback() {
        return this.callback;
    }

    @Override
    public void execute() {
        String string = this.requestDomain;
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            LPLog.INSTANCE.i(this.TAG, "Sending ACCDN connectors request...");
            String string2 = this.ACCDN_URL;
            Object[] objectArray = new Object[]{this.requestDomain, this.brandId};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            String connectorsUrl = string3;
            HttpGetRequest httpGetRequest = new HttpGetRequest(connectorsUrl, LPTraceType.ACCDN_CONNECTORS_REQ);
            httpGetRequest.setCertificatePinningKeys(this.certificates);
            httpGetRequest.setCallback(new ICallback<String, Exception>(this){
                final /* synthetic */ ACCDNConnectorsRequest this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSuccess(@Nullable String value) {
                    LPLog.INSTANCE.i(ACCDNConnectorsRequest.access$getTAG$p(this.this$0), "Successfully got connector information: " + value);
                    if (value == null || ACCDNConnectorsRequest.access$responseContainsError(this.this$0, value)) {
                        this.this$0.getCallback().onError((Exception)((Throwable)new Exception(value)));
                    } else {
                        this.this$0.getCallback().onSuccess(value);
                    }
                }

                public void onError(@Nullable Exception exception) {
                    LPLog.INSTANCE.w(ACCDNConnectorsRequest.access$getTAG$p(this.this$0), "Failed to get connector information: " + exception);
                    this.this$0.getCallback().onError((Exception)((Throwable)exception));
                }
            });
            HttpHandler.execute(httpGetRequest);
        }
    }

    private final boolean responseContainsError(String value) {
        try {
            JSONArray response = new JSONArray(value);
            if (response.length() > 0) {
                return false;
            }
        }
        catch (JSONException exception) {
            try {
                JSONObject response = new JSONObject(value);
                if (response.has("error")) {
                    LPLog.INSTANCE.w(this.TAG, "Got error response: " + response.get("error"));
                    return true;
                }
            }
            catch (Exception exception2) {
                return true;
            }
        }
        return true;
    }

    public static final /* synthetic */ String access$getTAG$p(ACCDNConnectorsRequest $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ boolean access$responseContainsError(ACCDNConnectorsRequest $this, String value) {
        return $this.responseContainsError(value);
    }
}

