/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.otel.LPTraceType;
import java.util.List;

public class ConfigurationRequest
implements Command {
    private static final String TAG = "ConfigurationRequest";
    private static final int CONFIGURATION_REQUEST_TIMEOUT = 30000;
    private static final String CONFIGURATION_URL = "https://%s/mobile/configuration/androidConfig.json";
    private String mConfigurationDomain;
    private ICallback<String, Exception> mCallback;
    private List<String> mCertificates;

    public ConfigurationRequest(String configurationDomain, List<String> certificates, ICallback<String, Exception> callback2) {
        this.mConfigurationDomain = configurationDomain;
        this.mCertificates = certificates;
        this.mCallback = callback2;
    }

    @Override
    public void execute() {
        String versionUrl = String.format(CONFIGURATION_URL, this.mConfigurationDomain);
        HttpGetRequest httpGetRequest = new HttpGetRequest(versionUrl, LPTraceType.LPCDN_SETTINGS_REQ);
        httpGetRequest.setTimeout(30000);
        httpGetRequest.setCertificatePinningKeys(this.mCertificates);
        httpGetRequest.setCallback(new ICallback<String, Exception>(){

            @Override
            public void onSuccess(String configurationStr) {
                if (!TextUtils.isEmpty((CharSequence)configurationStr)) {
                    LPLog.INSTANCE.d(ConfigurationRequest.TAG, "configurationRequest - onCompleted " + configurationStr);
                    ConfigurationRequest.this.mCallback.onSuccess(configurationStr);
                } else {
                    LPLog.INSTANCE.e(ConfigurationRequest.TAG, ErrorCode.ERR_0000004E, "onSuccess: configuration string is empty");
                    ConfigurationRequest.this.mCallback.onError(new Exception("Configuration string is empty"));
                }
            }

            @Override
            public void onError(Exception e) {
                LPLog.INSTANCE.d(ConfigurationRequest.TAG, "Exception: ", e);
                ConfigurationRequest.this.mCallback.onError(e);
            }
        });
        HttpHandler.execute(httpGetRequest);
    }
}

