/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.ThreadPoolExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\rH\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\rH\u0007J\u0012\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0003J$\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0007J$\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/liveperson/infra/utils/FileUtils;", "", "()V", "FILE_DIRS", "", "", "[Ljava/lang/String;", "TAG", "containsFiles", "", "context", "Landroid/content/Context;", "createTestFile", "Ljava/io/File;", "folder", "createTestFiles", "", "quantity", "", "deleteFileAsync", "root", "deleteFilesSync", "deleteRecursively", "fileOrDirectory", "getFilePath", "path", "filename", "writeFileContent", "privateDirectory", "publicDirectory", "Landroid/net/Uri;", "infra_release"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    private static final String TAG = "FileUtils";
    @NotNull
    private static final String[] FILE_DIRS;

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @JvmStatic
    public static final boolean writeFileContent(@NotNull Context context, @Nullable File privateDirectory, @Nullable Uri publicDirectory) {
        block18: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            inputStream = null;
            parcelFileDescriptor = null;
            fileOutputStream = null;
            try {
                inputStream = new FileInputStream(privateDirectory);
                v0 = publicDirectory;
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-FileUtils$writeFileContent$1 = 0;
                    v1 = context.getContentResolver().openFileDescriptor(it, "w");
                } else {
                    v1 = null;
                }
                v2 = parcelFileDescriptor = v1;
                fileOutputStream = new FileOutputStream(v2 != null ? v2.getFileDescriptor() : null);
                b = new byte[5120];
                len = 0;
                while (true) {
                    it = $i$a$-let-FileUtils$writeFileContent$1 = inputStream.read(b);
                    $i$a$-also-FileUtils$writeFileContent$2 = false;
                    len = it;
                    if ($i$a$-let-FileUtils$writeFileContent$1 <= 0) break;
                    fileOutputStream.write(b, 0, len);
                }
                ** try [egrp 1[TRYBLOCK] [0 : 122->148)] { 
            }
            catch (Exception e) {
                LPLog.INSTANCE.e("FileUtils", ErrorCode.ERR_00000012, "Failed to copy file from privateDir to publicDir. ", e);
                len = false;
                return len;
            }
            finally {
                try {
                    v4 = inputStream;
                    if (v4 != null) {
                        v4.close();
                    }
                    v5 = fileOutputStream;
                    if (v5 != null) {
                        v5.close();
                    }
                    v6 = parcelFileDescriptor;
                    if (v6 != null) {
                        v6.close();
                    }
                }
                catch (IOException exception) {
                    LPLog.INSTANCE.e("FileUtils", ErrorCode.ERR_00000013, "Failed to close fileOutputStream/parcelFileDescriptor ", exception);
                }
            }
lbl-1000:
            // 1 sources

            {
                inputStream.close();
                fileOutputStream.close();
                v3 = parcelFileDescriptor;
                if (v3 != null) {
                    v3.close();
                }
                break block18;
            }
lbl34:
            // 1 sources

            catch (IOException exception) {
                LPLog.INSTANCE.e("FileUtils", ErrorCode.ERR_00000013, "Failed to close fileOutputStream/parcelFileDescriptor ", exception);
            }
            {
            }
        }
        return true;
    }

    @JvmStatic
    @Nullable
    public static final File getFilePath(@NotNull Context context, @NotNull String path, @Nullable String filename) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File privateDir = new File(context.getApplicationContext().getFilesDir().toString() + path);
        File filePath = new File(privateDir, filename);
        if (!privateDir.exists() && !privateDir.mkdirs()) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000014, "getFilePath: folder could not be created");
            return null;
        }
        return filePath;
    }

    @JvmStatic
    public static final void deleteFilesSync(@NotNull File root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        String path = root.getPath();
        try {
            String[] $this$forEach$iv = FILE_DIRS;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                FilesKt.deleteRecursively((File)new File(path + it));
            }
        }
        catch (IOException ex) {
            String[] $this$forEach$iv = FILE_DIRS;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                FileUtils.deleteRecursively(new File(path + it));
            }
        }
    }

    @JvmStatic
    public static final void deleteFileAsync(@NotNull File root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ThreadPoolExecutor.execute(() -> FileUtils.deleteFileAsync$lambda-4(root));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @VisibleForTesting
    public static final boolean containsFiles(@NotNull Context context) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String path = context.getFilesDir().getPath();
        Object $this$map$iv = FILE_DIRS;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((String[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_15 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File(path + (String)it).exists());
        }
        $this$map$iv = (List)destination$iv$iv;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void current;
            n = ((Boolean)element$iv).booleanValue() ? 1 : 0;
            int prev = accumulator$iv;
            boolean bl = false;
            accumulator$iv = prev | current;
        }
        return accumulator$iv != 0;
    }

    @JvmStatic
    @VisibleForTesting
    public static final void createTestFiles(@NotNull Context context, int quantity) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String path = context.getFilesDir().getPath();
        String[] $this$forEach$iv = FILE_DIRS;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            File file;
            String element$iv;
            String dir = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            File it = file = new File(path + dir);
            boolean bl2 = false;
            if (!it.exists()) {
                it.mkdirs();
            }
            File folder = file;
            int n2 = 0;
            while (n2 < quantity) {
                int it2 = n2++;
                boolean bl3 = false;
                FileUtils.createTestFile(folder);
            }
        }
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final File createTestFile(@NotNull File folder) {
        File file;
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        String name = System.currentTimeMillis() + ".tmp";
        File it = file = new File(folder, name);
        boolean bl = false;
        boolean cfr_ignored_0 = it.exists() | it.createNewFile();
        return file;
    }

    @JvmStatic
    private static final void deleteRecursively(File fileOrDirectory) {
        if (fileOrDirectory == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000143, "file path is null");
            return;
        }
        if (fileOrDirectory.isDirectory()) {
            LPLog.INSTANCE.d(TAG, "deleteRecursive: deleting directory: " + fileOrDirectory.getAbsolutePath());
            File[] listFiles = fileOrDirectory.listFiles();
            if (listFiles == null) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000144, "File list is null");
                return;
            }
            File[] fileArray = fileOrDirectory.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"fileOrDirectory.listFiles()");
            for (File child : fileArray) {
                LPLog.INSTANCE.d(TAG, "deleteRecursive: deleting file: " + child.getAbsolutePath());
                FileUtils.deleteRecursively(child);
            }
        }
        fileOrDirectory.delete();
    }

    private static final void deleteFileAsync$lambda-4(File $root) {
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        FileUtils.deleteFilesSync($root);
    }

    static {
        String[] stringArray = new String[]{"/images", "/voice", "/documents"};
        FILE_DIRS = stringArray;
    }
}

