package com.liveperson.infra.analytics

/**
 * Class to compose each SDK event as an object of event name and event properties
 */
class AnalyticsEvent(val eventName: Any, vararg eventProperty: EventProperty) {
    private val eventProperties = eventProperty
    private var eventError: String? = ""

    /**
     * Return event properties as an array list
     */
    fun getEventProperties(): Array<out EventProperty> {
        return eventProperties
    }

    /**
     * Return api name of AnalyticsEvent enum
     */
    fun getEventName(): String {
        if (eventName is EventName.LivePerson) {
            return eventName.apiName
        }
        if (eventName is EventName.ConsumerAction) {
            return eventName.apiName
        }
        return ""
    }

    /**
     * If event contains an error in properties, return it.
     * TODO: Divide this into two functions to return error message and error code separately.
     */
    fun getError(): String? {
        for (property in eventProperties) {
            if (property.propertyName == "error") {
                if (property.propertyValue is String &&
                        property.propertyValue.isNotEmpty()) {
                    eventError = property.propertyValue
                }
            }
        }
        return eventError
    }
}