package com.liveperson.infra.analytics

/**
 * Note: when add new enum class -> update method AnalyticsEvent.getEventName()
 * @see AnalyticsEvent.getEventName()
 */
object EventName {
    enum class LivePerson(val apiName: String) {
        INITIALIZE("lpf_initialize"),
        SHOW_CONVERSATION_LP_CONTROL("lpf_show_conversation_lp_control"),
        SHOW_CONVERSATION_HOST_CONTROL("lpf_show_conversation_host_control"),
        REGISTER_PUSHER("lpf_register_pusher"),
        GET_UNREAD_MESSAGES_COUNT("lpf_get_unread_message_count"),
        HANDLE_PUSH("lpf_handle_push"),
        RECONNECT("lpf_reconnect"),
        LOGOUT("lpf_logout"),

        //Added by Shashank
        CHECK_ACTIVE_CONVERSATION("lpf_has_active_conversation"),
        CHECK_CONVERSATION_MARKED_URGENT("lpf_has_urgent_conversation"),
        CHECK_AGENT_ID("lpf_get_agent_profile"),
        MARK_CONVERSATION_URGENT("lpf_set_conversation_priority_urgent"),
        MARK_CONVERSATION_NORMAL("lpf_set_conversation_priority_normal"),
        RESOLVE_CONVERSATION("lpf_set_conversation_resolved"),
        SET_USER_PROFILE("lpf_set_user_profile"),
        CLEAR_HISTORY("lpf_clear_history"),
        SHUTDOWN("lpf_shutdown"),
        SET_IMAGE_SERVICE_PENDING_INTENT("lpf_set_img_svc_intent"),
        SET_PUSH_NOTIFICATIOM_TAPPED("lpf_set_push_notif_tapped"),
        IS_DEBUGGABLE("lpf_is_debuggable"),
        SET_IMAGE_SERVICE_DOWNLOAD_NOTIFICATION_BUILDER("lpf_set_img_svc_download_notif_builder"),
        SET_IMAGE_SERVICE_UPLOPAD_NOTIFICATION_BUILDER("lpf_set_img_svc_upload_notif_builder"),
        SET_LOG_LEVEL("lpf_set_log_level"),
        GET_LOG_LEVEL("lpf_get_log_dump"),
        GET_LOG_SNAPSHOT("lpf_get_log_snapshot"),
        GET_LOG_SNAPSHOT_STRING("lpf_get_log_snapshot_strings"),
        GET_LOG_SNAPSHOT_BLOCK("lpf_get_log_snapshot_block"),
        LOGGING_CLEAR_HISTORY("lpf_logging_clear_history"),
        SET_DATA_MASKING("lpf_set_data_masking"),
        IS_PUSHER_REGISTERED("lpf_is_pusher_registered"),
        UNREGISTER_PUSHER("lpf_unregister_pusher"),
        HIDE_CONVERSATION("lpf_hide_conversation"),
        UPDATE_TOKEN_IN_BACKGROUND("lpf_update_token_in_background"),
        REMOVE_CALLBACK("lpf_remove_lp_callback"),
        GET_SDK_VERSION("lpf_get_sdk_version"),
        SET_CALLBACK("lpf_set_lp_callback");
    }

    enum class ConsumerAction(val apiName: String) {
        REQUEST_CONVERSATION("action_request_conversation"),
        START_NEW_CONVERSATION("action_new_conversation_started"),
        SHOW_PROACTIVE_MESSAGE_IN_CONVERSATION("action_show_proactive_conversation_message"),
        CLICK_STRUCTURED_CONTENT("action_click_sc"),
        LOAD_SC_IMAGE_FAILED("action_load_sc_img_failed");
    }
}