package com.liveperson.infra.analytics.events

import com.liveperson.infra.analytics.*
import com.liveperson.infra.auth.LPAuthenticationType

open class LPAnalyticsConsumerActions(private val analyticsService: AnalyticsService) {

    companion object {
        private const val AUTH_TYPE = "auth_type"
        private const val CONVERSATION_ID = "conversation_id"
        private const val LANGUAGE = "language"
        private const val IS_OUTBOUND_CAMPAIGN_CONVERSATION = "isOutBoundCampaignConversation"
        private const val IS_PROACTIVE_RICH_CONTENT = "richContent"
        private const val SC_ACTION_TYPE = "action"
        private const val TRANSACTION_ID = "transaction_id"
        private const val IS_SUCCESS = "isSuccessRequest"
        private const val ERROR_START_CONVO = "error_message"
        private const val IMAGE_URL = "url"
        private const val ERROR = "error"
    }

    /**
     * Event to track sending request to create new conversation
     */
    fun trackRequestConversation(authType: LPAuthenticationType?, language: String, isOutBoundCampaignConversation: Boolean,
                                 is_proactive_rich_content: Boolean, transactionId: String?) {
        analyticsService.logUserEvent(AnalyticsEvent(EventName.ConsumerAction.REQUEST_CONVERSATION,
                EventProperty(AUTH_TYPE, authType),
                EventProperty(LANGUAGE, language),
                EventProperty(IS_OUTBOUND_CAMPAIGN_CONVERSATION, isOutBoundCampaignConversation),
                EventProperty(IS_PROACTIVE_RICH_CONTENT, is_proactive_rich_content),
                EventProperty(TRANSACTION_ID, transactionId)
            )
        )
    }

    /**
     * Event to track starting new conversation after sent request
     */
    fun trackStartNewConversation(authType: LPAuthenticationType?, language: String, is_success: Boolean,
                                  conversationId: String, transactionId: String?, error: String?) {
        analyticsService.logUserEvent(AnalyticsEvent(EventName.ConsumerAction.START_NEW_CONVERSATION,
                EventProperty(AUTH_TYPE, authType),
                EventProperty(LANGUAGE, language),
                EventProperty(IS_SUCCESS, is_success),
                EventProperty(CONVERSATION_ID, conversationId),
                EventProperty(TRANSACTION_ID, transactionId),
                EventProperty(ERROR_START_CONVO, error)
            )
        )
    }

    /**
     * Event to track when proactive message is processed and displayed on conversation window
     * It can be pure message or rich content with StructturedContent in the payload
     */
    fun trackShowProactiveAsWelcomeMessage(authType: LPAuthenticationType?, language: String, is_proactive_rich_content: Boolean, transactionId: String?) {
        analyticsService.logUserEvent(AnalyticsEvent(EventName.ConsumerAction.SHOW_PROACTIVE_MESSAGE_IN_CONVERSATION,
                EventProperty(AUTH_TYPE, authType),
                EventProperty(LANGUAGE, language),
                EventProperty(IS_PROACTIVE_RICH_CONTENT, is_proactive_rich_content),
                EventProperty(TRANSACTION_ID, transactionId)
            )
        )
    }

    /**
     * Event o track if consumer clicked on the clickable structured content
     */
    fun trackClickStructuredContent(authType: LPAuthenticationType?, language: String, is_proactive_rich_content: Boolean, scActionType: String) {
        analyticsService.logUserEvent(AnalyticsEvent(EventName.ConsumerAction.CLICK_STRUCTURED_CONTENT,
                EventProperty(AUTH_TYPE, authType),
                EventProperty(LANGUAGE, language),
                EventProperty(IS_PROACTIVE_RICH_CONTENT, is_proactive_rich_content),
                EventProperty(SC_ACTION_TYPE, scActionType)
            )
        )
    }

    /**
     * Event to track if the image URL in StructuredContent rendering failed
     */
    fun trackLoadSCImageFailed(authType: LPAuthenticationType?, language: String, imageUrl: String, error: String?) {
        analyticsService.logUserEvent(AnalyticsEvent(EventName.ConsumerAction.LOAD_SC_IMAGE_FAILED,
                EventProperty(AUTH_TYPE, authType),
                EventProperty(LANGUAGE, language),
                EventProperty(IMAGE_URL, imageUrl),
                EventProperty(ERROR, error)
            )
        )
    }
}