package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

/**
 * Created by ofira on 09/07/2015.
 * Modified by nirni on 08/11/2015.
 */
public interface BaseTable {

    String KEY_ID = "_id";

    /**
     * Get the create table SQL string
     *
     * @return create table string
     */
    String getCreateCommand();

    /**
     * This method is called upon DB upgrade
     *
     * @param db
     * @param oldVersion
     * @param newVersion
     */
    void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion);

    String getName();

    String getTableName();
}
