package com.liveperson.infra.log

/**
 * Implementation of a Logger that writes everything System.out and System.err.
 * Non-Production implementation that should be used **ONLY** in Unit Tests.
 * Must not be used in Production.
 */
class TestLoggingDelegate : LoggingDelegate {

	override fun v(tag: String, message: String, exception: Throwable?) {
		if (exception != null) {
			println("[v]  $message\n${exception.message}")
			exception.printStackTrace(System.out)
		} else {
			println("[v]  $message")
		}
	}

	override fun d(tag: String, message: String, exception: Throwable?) {
		if (exception != null) {
			println("[d]  $message\n${exception.message}")
			exception.printStackTrace(System.out)
		} else {
			println("[d]  $message")
		}
	}

	override fun i(tag: String, message: String, exception: Throwable?) {
		if (exception != null) {
			println("[i]  $message\n${exception.message}")
			exception.printStackTrace(System.out)
		} else {
			println("[i]  $message")
		}
	}

	override fun w(tag: String, message: String, exception: Throwable?) {
		if (exception != null) {
			println("[w]  $message\n${exception.message}")
			exception.printStackTrace(System.out)
		} else {
			println("[w]  $message")
		}
	}

	override fun e(tag: String, message: String, exception: Throwable?) {
		if (exception != null) {
			System.err.println("[e]  $message\n${exception.message}")
			exception.printStackTrace(System.err)
		} else {
			System.err.println("[e]  $message")
		}
	}

	override fun wtf(tag: String, message: String, exception: Throwable?) {
		if (exception != null) {
			System.err.println("[wtf]  $message\n${exception.message}")
			exception.printStackTrace(System.err)
		} else {
			System.err.println("[wtf]  $message")
		}
	}
}
