package com.liveperson.infra.network.http

/**
 * Thrown to indicate that http call is completed with failure.
 * Class used to determine root cause of any flow that uses http calls
 * under the hood.
 *
 * @param code - [http code](https://developer.mozilla.org/en-US/docs/Web/HTTP/Status)
 * used to determine the cause of http request failure.
 * @param body - string representation of response returned by request.
 * Could contains JSON, XML or plain string data.
 */
class HttpException(
    val code: Int,
    val body: String?
): Exception() {

    override val message: String = "On Response Error: response code: $code, response body: ${body ?: "no Response"}"
}