package com.liveperson.infra.network.http.client

import okhttp3.Interceptor
import okhttp3.Request
import okhttp3.Response
import java.util.concurrent.TimeUnit

/**
 * Class used to set a timeout per each request
 * without building new okhttp client.
 */
class TimeoutInterceptor: Interceptor {

    companion object {
        const val HEADER_TIMEOUT = "LP-timeout"
    }
    override fun intercept(chain: Interceptor.Chain): Response {
        val currentRequest = chain.request();
        val timeout = currentRequest.header(HEADER_TIMEOUT)?.toIntOrNull()
        return chain
            .run { if (timeout != null) chainTimeout(timeout) else this }
            .proceed(currentRequest.withoutHeader(HEADER_TIMEOUT))
    }

    private fun Request.withoutHeader(header: String) = newBuilder().removeHeader(header).build()

    private fun Interceptor.Chain.chainTimeout(timeout: Int) = withConnectTimeout(timeout, TimeUnit.MILLISECONDS)
            .withReadTimeout(timeout, TimeUnit.MILLISECONDS)
            .withWriteTimeout(timeout, TimeUnit.MILLISECONDS)
}