package com.liveperson.infra.network.http.request;

import com.liveperson.infra.otel.LPTraceType;

import okhttp3.Response;

/**
 * Created by shiranr on 9/19/16.
 */
public class HttpOpenStreamRequest extends HttpGetRequest {
    public HttpOpenStreamRequest(String uri) {
        super(uri, LPTraceType.HTTP_REQUEST);
    }

    @Override
    public void reportSuccess(Response response) {
        if (mCallback != null){
            if (response == null){
                processErrorResponse(new Exception("No Stream Available!"));
            }else{
                mCallback.onSuccess(response);
            }
        }
    }
}
