package com.liveperson.infra.network.http.requests;

import androidx.annotation.NonNull;
import android.text.TextUtils;

import com.liveperson.infra.PushUnregisterType;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.log.LPLog;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;
import java.util.Objects;

import static com.liveperson.infra.errors.ErrorCode.ERR_0000004D;

/**
 * Created by nirni on 1/27/16.
 */
public class UnregisterPushRequest extends PushRequest {

	private static final String TAG = "UnregisterPushRequest";
	private static final String KEY_SOFT_DELETE = "softDelete";
	private PushUnregisterType unregisterType;


	public UnregisterPushRequest(String pusherURL, String userId, String appId, String platform, String authType, List<String> certificates) {
		super(pusherURL, userId, appId, null, null, platform, authType, certificates, false);
	}

	@Override
	public void handleResponse(String json) {
		if (!TextUtils.isEmpty(json)) {
			LPLog.INSTANCE.d(TAG, "onSuccess " + json);
			if (mCallback != null) {
				mCallback.onSuccess(null);
			}
		}else{
			LPLog.INSTANCE.e(TAG, ERR_0000004D, "Unregister pusher with empty response");
		}
	}

	@Override
	public void handleError(Exception exception) {
		if (exception != null) {
			LPLog.INSTANCE.d(TAG, "onError ", exception);
			if (mCallback != null) {
				if (exception.getMessage().contains("Token not found")) {
					LPLog.INSTANCE.d(TAG, "handleError: token not found on pusher. Return success");
					mCallback.onSuccess(null);
					return;
				}
				mCallback.onError(new Exception("Failed to unregister to pusher. response message = ", exception));
			}
		}
	}

	@NonNull
	@Override
	protected JSONObject getBody() {

		JSONObject pusherJson = new JSONObject();

		try {
			pusherJson.put(KEY_APP_ID, mAppId);
			pusherJson.put(KEY_USER_ID, mUserId);
			pusherJson.put(KEY_PLATFORM, mPlatform);
			pusherJson.put(KEY_SOFT_DELETE, (unregisterType == PushUnregisterType.AGENT && Objects.equals(userAuthType, LPAuthenticationType.AUTH.name())));

		} catch (JSONException ignored) {}

		return pusherJson;
	}

	public UnregisterPushRequest setUnregisterType(PushUnregisterType type) {
		unregisterType = type;
		return this;
	}
}
