package com.liveperson.infra.network.socket;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Ilya Gazman on 11/2/2015.
 *
 * this is the base class for server responses
 *
 * @param <DATA> the value object of the response
 * @param <REQUEST> the server request that inherit from BaseSocketRequest
 */
public abstract class BaseResponseHandler<DATA, REQUEST extends BaseSocketRequest> {

    private REQUEST mBaseSocketRequest;

    /**
     * Here is handled the parsing process of the request
     * @param jsonObject
     * @return
     * @throws JSONException
     */
    protected abstract DATA parse(JSONObject jsonObject) throws JSONException;

    /**
     * After the parsing process it will come here with DATA value object
     * @param data
     */
    protected abstract boolean handle(DATA data);

    /**
     * @return the BaseSocketRequest mapped to this response
     */
    protected REQUEST getRequest() {
        return mBaseSocketRequest;
    }

    public abstract String getAPIResponseType();

    /**
     * Used to map BaseSocketRequest to this response
     * @param baseSocketRequest
     * @param <T>
     */
    <T extends REQUEST> void init(T baseSocketRequest) {
        this.mBaseSocketRequest = baseSocketRequest;
    }

    protected BaseResponseHandler getSupportedResponseHandler(String messageType){
        return null;
    }

    protected void giveUp() {
    }

    public BaseResponseHandler getResponseByExpectedType(String expectedType){
        return this;
    }
}
