package com.liveperson.infra.otel

import com.liveperson.infra.otel.OtelUtils.SPAN_KIND_CLIENT
import com.liveperson.infra.otel.models.OtlpAttribute
import com.liveperson.infra.otel.models.OtlpValueData
import okhttp3.internal.toImmutableList

interface LPTraceSpanDelegate {
    fun end(id: String)
    fun cancel(id: String)
}

class LPTraceSpan(
    val name: String,
    val startTimeUnixNano: Long,
    val spanId: String,
    val traceId: String,
    var endTimeUnixNano: Long?,
    val kind: Int = SPAN_KIND_CLIENT,
    val parentSpanId: String? = null,
    attributes: List<OtlpAttribute> = emptyList(),
    private val delegate: LPTraceSpanDelegate? = null,
) {

    private val _attributes = attributes.toMutableList()

    val attributes: List<OtlpAttribute>
        get() = _attributes.toImmutableList()

    fun end() {
        delegate?.end(this.spanId)
    }

    fun cancel() {
        delegate?.cancel(this.spanId)
    }

    fun addAttribute(key: LPTelemetryAttributeKey, value: String) {
        _attributes.add(OtlpAttribute(key.value, OtlpValueData.StringValue(value)))
    }

    fun addAttribute(key: LPTelemetryAttributeKey, value: Long) {
        _attributes.add(OtlpAttribute(key.value, OtlpValueData.LongValue(value)))
    }
}
