package com.liveperson.infra.otel.exporters

import com.liveperson.infra.network.http.body.HttpRequestBody
import com.nimbusds.jose.shaded.gson.JsonObject

class OtlpJsonObjectBody(val jsonObject: JsonObject) : HttpRequestBody {
    override fun get(): String {
        return jsonObject.toString()
    }

    override fun isString(): Boolean {
        return true
    }

    override fun getContentType(): String {
        return "application/json"
    }
}