package com.liveperson.infra.utils

import android.app.Activity
import android.content.Context
import android.content.res.Resources
import android.content.res.TypedArray
import android.net.Uri
import android.os.Build
import android.util.DisplayMetrics
import android.view.WindowManager
import androidx.annotation.IdRes
import androidx.core.content.FileProvider
import com.liveperson.infra.BuildConfig
import com.liveperson.infra.Infra

import java.io.File

/*
* Excluded from jacoco report.
* Unit testing comment: No need to test android framework.
* */
object AndroidFrameworkUtils {

    @JvmStatic
    val manufacturer: String
        get() = Build.MANUFACTURER

    @JvmStatic
    val sdkVersion: Int
        get() = Build.VERSION.SDK_INT

    @JvmStatic
    val isDebug: Boolean
        get() = BuildConfig.DEBUG

    @JvmStatic
    fun getUriForFile(context: Context, folder: File): Uri {
        val file = File(folder, "image${System.currentTimeMillis()}.jpg")
            .also { it.createNewFile() }
        return FileProvider.getUriForFile(
            context,
            Infra.getFileProviderAuthorityPrefix() + context.packageName,  // The prefix here is the same as defined in the provider in the manifest
            file
        )
    }

    @JvmStatic
    val WindowManager.displayMetrics: DisplayMetrics
        get() {
            val displayMetrics = DisplayMetrics()
            this.defaultDisplay?.getMetrics(displayMetrics)
            return displayMetrics
        }

    @JvmStatic
    val WindowManager.displayMetricsHeight: Int
        get() = this.displayMetrics.heightPixels

    @JvmStatic
    val WindowManager.displayMetricsWidth: Int
        get() = this.displayMetrics.widthPixels

    @JvmStatic
    fun obtainStyledAttributesByResID(activity: Activity?, @IdRes resId: Int): TypedArray? {
        return activity?.theme?.obtainStyledAttributes(intArrayOf(resId))
    }

    @JvmStatic
    val Context.appVersion: String
        get() = packageManager.getPackageInfo(this.packageName, 0).versionName

    @JvmStatic
    val resources: Resources
        get() = Infra.instance.applicationContext.resources
}