package com.liveperson.infra.utils

import android.os.Bundle
import android.speech.RecognitionListener
import android.speech.SpeechRecognizer
import android.widget.EditText

class LpRecognitionListener(
    private var editText: EditText,
    var callback: LPAudioUtils.SpeechRecognitionResultCallback
) : RecognitionListener {

    private var stringBuilder : StringBuilder = StringBuilder()

    private var speechInProgress = false

    override fun onReadyForSpeech(params: Bundle?) {
    }

    override fun onSegmentResults(segmentResults: Bundle) {
        handleResult(segmentResults)
    }

    override fun onEndOfSegmentedSession() {
        callback.onStopListening()
    }

    override fun onLanguageDetection(results: Bundle) {
    }

    override fun onBeginningOfSpeech() {
        callback.refreshProgressBar()
        speechInProgress = true
        stringBuilder.clear()
        stringBuilder.append(editText.text)
        requestFocusOnTextInput()
    }

    override fun onRmsChanged(rmsdB: Float) {
        if (speechInProgress && rmsdB.compareTo(RMS_LEVEL_THRESHOLD) >= 0) {
            callback.refreshProgressBar()
        }
    }

    override fun onBufferReceived(buffer: ByteArray?) {
    }

    override fun onEndOfSpeech() {
        speechInProgress = false
    }

    override fun onError(error: Int) {
        callback.onStopListening()
        speechInProgress = false
    }

    override fun onResults(results: Bundle) {
        handleResult(results)
        callback.onStopListening()
    }

    private fun handleResult(results: Bundle){
        val data = results.getStringArrayList(SpeechRecognizer.RESULTS_RECOGNITION)
        if (!data.isNullOrEmpty()) {
            stringBuilder.append(data[0])
            editText.tag = TEXT_SOURCE_SPEECH_RECOGNITION
            editText.setText(stringBuilder)
            requestFocusOnTextInput()
            editText.tag = null
        }
    }

    override fun onPartialResults(partialResults: Bundle) {
        val data = partialResults.getStringArrayList(SpeechRecognizer.RESULTS_RECOGNITION)
        if (!data.isNullOrEmpty()) {
            editText.tag = TEXT_SOURCE_SPEECH_RECOGNITION
            editText.setText("")
            editText.append(stringBuilder)
            editText.append(data[0])
            requestFocusOnTextInput()
            editText.tag = null
        }
    }

    override fun onEvent(eventType: Int, params: Bundle?) {
    }

    private fun requestFocusOnTextInput() {
        editText.requestFocus()
        editText.setSelection(editText.length())
    }

    companion object {
        private const val RMS_LEVEL_THRESHOLD = 8f // This threshold was defined experimentally. Potentially could be in range 6-9.
        const val TEXT_SOURCE_SPEECH_RECOGNITION = "TEXT_SOURCE_SPEECH_RECOGNITION"
    }
}