package com.liveperson.infra.utils;

import android.os.Build;

import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.Tls12SocketFactory;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;

import static com.liveperson.infra.errors.ErrorCode.ERR_0000002B;

/**
 * Remove this class once minSdkVersion is higher than KitKat.
 * //todo: Reconsider actuality of this class. 04/08/22 - minSDK  = 21. Kitkat = 19.
 * Created by Yanda on 2019/03/08
 */
public class TlsUtil {

    private static final String TAG = "TlsUtil";
    private static final String TLS_1_2 = "TLSv1.2";

    /**
     * Enable TLSv1.2 for KitKat.
     *
     * @param client The OkHttpClient builder.
     */
    public static void enableTls12ForKitKat(OkHttpClient.Builder client) {
        if (Build.VERSION.SDK_INT == Build.VERSION_CODES.KITKAT) {
            try {
                SSLContext sc = SSLContext.getInstance(TLS_1_2);
                sc.init(null, null, null);
                client.sslSocketFactory(new Tls12SocketFactory(sc.getSocketFactory()), systemDefaultTrustManager());

                ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS)
                        .tlsVersions(TlsVersion.TLS_1_2)
                        .build();

                List<ConnectionSpec> specs = new ArrayList<>();
                specs.add(cs);
                specs.add(ConnectionSpec.COMPATIBLE_TLS);
                specs.add(ConnectionSpec.CLEARTEXT);
                client.connectionSpecs(specs);
            } catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ERR_0000002B, "Error while setting TLS 1.2", e);
            }
        }
    }

    /**
     * @return The default TrustManager that OkHttpClient is using
     */
    private static X509TrustManager systemDefaultTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(
                    TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore) null);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:"
                        + Arrays.toString(trustManagers));
            }
            return (X509TrustManager) trustManagers[0];
        } catch (GeneralSecurityException e) {
            return null; // The system has no TLS. Just give up.
        }
    }
}
