/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.database.tables;

import android.database.sqlite.SQLiteDatabase;
import com.liveperson.infra.database.tables.BaseTable;
import com.liveperson.infra.log.LPLog;

public class DialogsTable
implements BaseTable {
    private static final String TAG = "DialogsTable";
    public static final String TABLE_NAME = "dialogs";

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String getCreateCommand() {
        return "create table dialogs(_id integer primary key autoincrement,dialog_id text unique,conversation_id text,dialog_type text,channel_type text,brand_id text,target_id text,assigned_agent_id text,unread_msg_count integer default -1,start_timestamp big int not null,request_id big int,ttr_type integer,last_server_sequence integer default -1,csat_status long default -1,end_timestamp long default -1,close_reason integer default -1,concurrent_requests_counter integer default 0,state integer, UNIQUE ( dialog_id) ON CONFLICT IGNORE);";
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (newVersion == 6) {
            LPLog.INSTANCE.i(TAG, "It's the version of this table's arrival");
        }
    }

    public class Key {
        public static final String CONVERSATION_ID = "conversation_id";
        public static final String DIALOG_ID = "dialog_id";
        public static final String DIALOG_TYPE = "dialog_type";
        public static final String CHANNEL_TYPE = "channel_type";
        public static final String BRAND_ID = "brand_id";
        public static final String TARGET_ID = "target_id";
        public static final String UNREAD_MESSAGES_COUNT = "unread_msg_count";
        public static final String CLOSE_REASON = "close_reason";
        public static final String START_TIMESTAMP = "start_timestamp";
        public static final String END_TIMESTAMP = "end_timestamp";
        public static final String CSAT_STATUS = "csat_status";
        public static final String TTR_TYPE = "ttr_type";
        public static final String ASSIGNED_AGENT_ID = "assigned_agent_id";
        public static final String LAST_SERVER_SEQUENCE = "last_server_sequence";
        public static final String REQUEST_ID = "request_id";
        public static final String STATE = "state";
        public static final String CONCURRENT_REQUESTS_COUNTER = "concurrent_requests_counter";
    }
}

