/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.client;

import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.client.TimeoutInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Callback;
import okhttp3.CertificatePinner;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J&\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0016\u0010\u001a\u001a\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/liveperson/infra/network/http/client/OkHttpClientHolder;", "", "()V", "CONNECT_TIMEOUT_IN_MINUTES", "", "PERIODIC_PING_TIME", "READ_TIMEOUT_IN_MINUTES", "TAG", "", "WRITE_TIMEOUT_IN_MINUTES", "_okHttpClient", "Lokhttp3/OkHttpClient;", "buildNewClient", "cancelAllRequests", "", "newSocket", "Lokhttp3/WebSocket;", "request", "Lokhttp3/Request;", "listener", "Lokhttp3/WebSocketListener;", "proceed", "keys", "", "callback", "Lokhttp3/Callback;", "setInterceptors", "interceptors", "Lokhttp3/Interceptor;", "infra_release"})
public final class OkHttpClientHolder {
    @NotNull
    public static final OkHttpClientHolder INSTANCE = new OkHttpClientHolder();
    @NotNull
    private static final String TAG = "OkHttpClientHolder";
    private static final long PERIODIC_PING_TIME = 20000L;
    private static final long CONNECT_TIMEOUT_IN_MINUTES = 1L;
    private static final long READ_TIMEOUT_IN_MINUTES = 1L;
    private static final long WRITE_TIMEOUT_IN_MINUTES = 1L;
    @NotNull
    private static OkHttpClient _okHttpClient = INSTANCE.buildNewClient();

    private OkHttpClientHolder() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final synchronized void setInterceptors(@NotNull List<? extends Interceptor> interceptors) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        List oldInterceptors = _okHttpClient.interceptors();
        if (oldInterceptors.containsAll((Collection)interceptors)) {
            LPLog.INSTANCE.d(TAG, "Interceptors are the same. Skipping building new client.");
            return;
        }
        OkHttpClient.Builder builder = _okHttpClient.newBuilder();
        Iterable $this$filterNot$iv = interceptors;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Interceptor it = (Interceptor)element$iv$iv;
            boolean bl = false;
            if (oldInterceptors.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Interceptor it = (Interceptor)element$iv;
            boolean bl = false;
            builder.addInterceptor(it);
        }
        _okHttpClient = builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final synchronized void proceed(@NotNull Request request, @NotNull List<String> keys, @NotNull Callback callback2) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Iterable iterable = keys;
        CertificatePinner.Builder initial$iv = new CertificatePinner.Builder();
        boolean $i$f$fold = false;
        CertificatePinner.Builder accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void key;
            String string = (String)element$iv;
            CertificatePinner.Builder cert = accumulator$iv;
            boolean bl = false;
            String[] stringArray = new String[]{key};
            accumulator$iv = cert.add("*", stringArray);
        }
        CertificatePinner requestKeys = accumulator$iv.build();
        if (Intrinsics.areEqual((Object)_okHttpClient.certificatePinner().getPins(), (Object)requestKeys.getPins())) {
            LPLog.INSTANCE.d(TAG, "Pinning keys are the same. Skipping building new client.");
        } else {
            _okHttpClient = _okHttpClient.newBuilder().certificatePinner(requestKeys).build();
        }
        _okHttpClient.newCall(request).enqueue(callback2);
    }

    @JvmStatic
    public static final synchronized void cancelAllRequests() {
        _okHttpClient.dispatcher().cancelAll();
    }

    @JvmStatic
    @NotNull
    public static final synchronized WebSocket newSocket(@NotNull Request request, @NotNull WebSocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return _okHttpClient.newWebSocket(request, listener);
    }

    private final OkHttpClient buildNewClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        return builder.addInterceptor((Interceptor)new TimeoutInterceptor()).pingInterval(20000L, TimeUnit.MILLISECONDS).connectTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).followRedirects(true).build();
    }
}

