/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.liveperson.infra.PushUnregisterType;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.requests.PushRequest;
import java.util.List;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class UnregisterPushRequest
extends PushRequest {
    private static final String TAG = "UnregisterPushRequest";
    private static final String KEY_SOFT_DELETE = "softDelete";
    private PushUnregisterType unregisterType;

    public UnregisterPushRequest(String pusherURL, String userId, String appId, String platform, String authType, List<String> certificates) {
        super(pusherURL, userId, appId, null, null, platform, authType, certificates, false);
    }

    @Override
    public void handleResponse(String json) {
        if (!TextUtils.isEmpty((CharSequence)json)) {
            LPLog.INSTANCE.d(TAG, "onSuccess " + json);
            if (this.mCallback != null) {
                this.mCallback.onSuccess(null);
            }
        } else {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000004D, "Unregister pusher with empty response");
        }
    }

    @Override
    public void handleError(Exception exception) {
        if (exception != null) {
            LPLog.INSTANCE.d(TAG, "onError ", exception);
            if (this.mCallback != null) {
                if (exception.getMessage().contains("Token not found")) {
                    LPLog.INSTANCE.d(TAG, "handleError: token not found on pusher. Return success");
                    this.mCallback.onSuccess(null);
                    return;
                }
                this.mCallback.onError(new Exception("Failed to unregister to pusher. response message = ", exception));
            }
        }
    }

    @Override
    @NonNull
    protected JSONObject getBody() {
        JSONObject pusherJson = new JSONObject();
        try {
            pusherJson.put("appId", (Object)this.mAppId);
            pusherJson.put("lpid", (Object)this.mUserId);
            pusherJson.put("platform", (Object)this.mPlatform);
            pusherJson.put(KEY_SOFT_DELETE, this.unregisterType == PushUnregisterType.AGENT && Objects.equals(this.userAuthType, LPAuthenticationType.AUTH.name()));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return pusherJson;
    }

    public UnregisterPushRequest setUnregisterType(PushUnregisterType type) {
        this.unregisterType = type;
        return this;
    }
}

