package com.liveperson.infra.network.http.request;

import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.otel.LPTraceType;

/**
 * Created by ofira on 03/11/2015.
 */
public class HttpPostRequest extends HttpRequest {

    private static final HttpMethod METHOD = HttpMethod.POST;

    public HttpPostRequest(String uri, LPTraceType traceType) {
        super(uri, METHOD, traceType);
    }

    @Override
    public void setBody(HttpRequestBody body) {
        mRequestBody = body;
    }

    @Override
    public HttpRequestBody getRequestBody() {
        return mRequestBody;
    }
}
