package com.liveperson.infra.otel

enum class LPTraceType(val value: String) {
    NOT_TRACKING("notTracking"),
    INIT_SDK("initializeSdk"),
    SHOW_CONV("showConversation"),
    SHOW_CONV_BG_FG("showConversationBackgroundToForeground"),

    ENABLE_OFFLINE_MESSAGING("enableOfflineMessagingForConsumer"),

    RECONNECT_AFTER_TOKEN_EXPIRED("reconnectAfterTokenExpired"),
    RECONNECT_AFTER_NETWORK_STATUS_CHANGED("reconnectAfterNetworkStatusChanged"),

    VALIDATE_TOKEN("validateToken"),

    AUTHENTICATION_ANONYMOUS_FLOW("authenticationAnonymousFlow"),
    AUTHENTICATION_AUTHED_FLOW("authenticationAuthenticatedFlow"),
    AUTHENTICATION_NON_AUTHED_FLOW("authenticationNonAuthFlow"),
    AUTHENTICATION_SIGNUP_FLOW("authenticationSignUpFlow"),
    AUTHENTICATION_STEP_UP_FLOW("authenticationStepUpFlow"),
    AUTHENTICATION_CODE_PKCE_FLOW("authenticationCodePKCEFlow"),

    HTTP_REQUEST("httpRequest"),
    PERFORM_AUTH_WITH_BODY_REQ("performAuthWithBodyRequest"),
    PERFORM_AUTH_WITHOUT_BODY_REQ("performAuthWithoutBodyRequest"),
    GET_JWKS_KEY_REQ("getJWKSKeyRequest"),
    TRACE_REQ("traceRequest"),

    INCA_CONV_LIST_REQ("INCAConversationListRequest"),
    INCA_HANDLE_CONV_LIST_RES("INCAHandleConversationListResponse"),
    INCA_GET_CONV_MESSAGES_REQ("INCAGetConversationMessagesRequest"),
    INCA_HANDLE_CONV_MESSAGES_RES("INCAHandleConversationMessagesResponse"),

    // pusher
    PUSHER_REGISTER_REQ("pusherRegisterRequest"),
    PUSHER_READ_ACK_REQ("pusherReadAcknowledgementRequest"),
    PUSHER_CLEAR_BADGE_COUNT_REQ("pusherClearBadgeCountRequest"),
    PUSHER_IS_REGISTER_REQ("pusherIsRegisteredRequest"),
    PUSHER_UNREGISTER_REQ("pusherUnregisterRequest"),
    PUSHER_UNREAD_MSG_COUNT_REQ("pusherUnreadMessageCountRequest"),
    PUSHER_UNREAD_MSG_COUNT_REQ_V2("pusherUnreadMessageCountRequestV2"),

    // UMS
    UMS_GET_CLOCK_REQ("UMSGetClockRequest"),
    UMS_GET_USER_PROFILE_REQ("UMSGetUserProfileRequest"),
    UMS_REQUEST_CONV_REQ("UMSRequestConversationRequest"),
    UMS_UNREAD_MSG_REQ("UMSUnreadMessageCountRequest"),
    UMS_GET_CONV_LIST("UMSGetConversationList"),
    UMS_GET_CONV_MESSAGES("UMSGetConversationMessages"),
    UMS_OPEN_SOCKET("UMSOpenSocket"),
    UMS_OPEN_EXISTING_SOCKET("UMSOpenExistingSocket"),

    /// Shark
    SHARK_SEND_SDE_REQ("sharkSendSDERequest"),
    SHARK_GET_ENGAGEMENT_REQ("sharkGetEngagementRequest"),

    /// ACCDN
    ACCDN_SETTINGS_REQ("ACCDNSettingsRequest"),
    ACCDN_CONNECTORS_REQ("ACCDNConnectorsRequest"),
    ACCDN_ENGAGEMENT_REQ("ACCDNEngagementRequest"),
    ACCDN_USER_DETAILS_REQ("ACCDNUserDetailsRequest"),
    ACCDN_WINDOW_CONFIG_REQ("ACCDNWindowConfigurationRequest"),

    LPCDN_SETTINGS_REQ("LPCDNSettingsRequest"), // ConfigurationRequest
    CSDS_DOMAINS_REQ("CSDSDomainsRequest"),
    LP_TAG_REQ("LPTagRequest"),

    DOWNLOAD_FILE_REQ("downloadFileRequest"),
    UPLOAD_FILE_REQ("uploadFileRequest"),
    GENERATE_FILE_SHARING_DOWNLOAD_URL_REQ("generateFileSharingDownloadURLRequest"),

    GENERATE_AUDIO("generateAudio"),
    GENERATE_FILE("generateFile"),
    GENERATE_PHOTO("generatePhoto"),
    LOGOUT("logout"),
    CLEAR_HISTORY("clearHistory"),

    MASKING_LOCAL_MESSAGES_FROM_INCA("maskingUpdateLocalMessagesFromINCA"),

    /// To capture the event of CSDS change after adding LPTag changes this might occur since Otel base URI is dynamic
    /// does not capture whole disconnect and connect flow it is an indicator that SDK got CSDS Change
    CSDS_DOMAINS_CHANGED("CSDSDomainsChanged")
}