/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.infra.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CSDSRequest
implements Command {
    private static final String TAG = "CSDSRequest";
    private static final String CSDS_URL = "https://%1$s/csdr/account/%2$s/service/baseURI.json?version=1.0";
    private static final String CSDS_SERVICE_BASED_URL = "https://%1$s/csdr/account/%2$s/service/%3$s/baseURI.json?version=1.0";
    private static final int CSDS_REQUEST_TIMEOUT = 30000;
    private ICallback<HashMap<String, String>, Exception> mCallback;
    private String mBrandId;
    private String mDomain;
    private List<String> mCertificates;
    private String mServiceName;

    public CSDSRequest(String domain, String brandId, List<String> certificates, ICallback<HashMap<String, String>, Exception> callback2) {
        this(domain, brandId, "", certificates, callback2);
    }

    public CSDSRequest(String domain, String brandId, String serviceName, List<String> certificates, ICallback<HashMap<String, String>, Exception> callback2) {
        this.mCallback = callback2;
        this.mBrandId = brandId;
        this.mCertificates = certificates;
        this.mDomain = domain;
        this.mServiceName = serviceName;
    }

    @Override
    public void execute() {
        final String cSDSRequestUrl = StringUtils.isEmpty(this.mServiceName) ? String.format(CSDS_URL, this.mDomain, this.mBrandId) : String.format(CSDS_SERVICE_BASED_URL, this.mDomain, this.mBrandId, this.mServiceName);
        HttpGetRequest httpGetRequest = new HttpGetRequest(cSDSRequestUrl, LPTraceType.CSDS_DOMAINS_REQ);
        httpGetRequest.setTimeout(30000);
        httpGetRequest.setCertificatePinningKeys(this.mCertificates);
        httpGetRequest.setCallback(new ICallback<String, Exception>(){

            @Override
            public void onSuccess(String csdsString) {
                block5: {
                    if (!StringUtils.isEmpty(csdsString)) {
                        try {
                            JSONArray csdsResponse;
                            JSONObject csdsJson = new JSONObject(csdsString);
                            JSONArray jSONArray = csdsResponse = csdsJson.has("baseURIs") ? csdsJson.optJSONArray("baseURIs") : new JSONArray().put((Object)csdsJson);
                            if (csdsResponse.length() == 0) {
                                CSDSRequest.this.mCallback.onError(new Exception("CSDS response: Brand not found. url = " + cSDSRequestUrl));
                                break block5;
                            }
                            HashMap mCSDSUrls = CSDSRequest.this.parseCSDSResponse(csdsResponse);
                            CSDSRequest.this.mCallback.onSuccess(mCSDSUrls);
                        }
                        catch (JSONException je) {
                            CSDSRequest.this.mCallback.onError(je);
                        }
                    } else {
                        CSDSRequest.this.mCallback.onError(new Exception("CSDS response: csdsString is empty"));
                    }
                }
            }

            @Override
            public void onError(Exception exception) {
                LPLog.INSTANCE.w(CSDSRequest.TAG, "CSDS failed! url = " + cSDSRequestUrl + ". error: ", exception);
                CSDSRequest.this.mCallback.onError(exception);
            }
        });
        HttpHandler.execute(httpGetRequest);
    }

    private HashMap<String, String> parseCSDSResponse(JSONArray cSDSResponse) {
        HashMap<String, String> mCSDSUrls = new HashMap<String, String>(cSDSResponse.length());
        for (int i = 0; i < cSDSResponse.length(); ++i) {
            JSONObject service = cSDSResponse.optJSONObject(i);
            String serviceName = service.optString("service");
            String baseURIName = service.optString("baseURI");
            LPLog.INSTANCE.d(TAG, "serviceName: " + serviceName + " : " + baseURIName);
            mCSDSUrls.put(serviceName, baseURIName);
        }
        return mCSDSUrls;
    }
}

