package com.liveperson.infra.otel

enum class LPTelemetryAttributeKey(val value: String) {
    METHOD("http.request.method"),
    URL_FULL("url.full"),
    SERVICE_NAME("service.name"),
    TELEMETRY_SDK_VERSION("telemetry.sdk.version"),
    TELEMETRY_SDK_NAME("telemetry.sdk.name"),
    TELEMETRY_SDK_LANGUAGE("telemetry.sdk.language"),
    OS_VERSION("os.version"),
    OS_TYPE("os.type"),

    //Resource/Device - https://opentelemetry.io/docs/specs/semconv/resource/device/

    // The model identifier for the device
    DEVICE_MODEL_IDENTIFIER("device.model.identifier"),

    //LP Internal
    LP_CAMPAIGN_ID("lp.engagement.campaignId"),
    LP_ENGAGEMENT_ID("lp.engagement.engagementId"),
    LP_CONTEXT_ID("lp.engagement.contextId"),
    LP_SESSION_ID("lp.engagement.sessionId"),
    LP_VISITOR_ID("lp.engagement.visitorId"),
    LP_ACCOUNT_ID("lp.account.id")
}
