package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

/**
 * Created by shayl on 7/22/2015.
 */
public class FilesTable implements BaseTable {

    private static final String TAG = "FilesTable";

    //Messages table name
    public static final String FILES_TABLE = "files";

    //Messages table columns
    public static final String KEY_ID_AS_VALUE = "file_row_id";
    public static final String KEY_PREVIEW = "preview";
    public static final String KEY_SWIFT_PATH = "swiftPath";
    public static final String KEY_FILE_TYPE = "fileType";
    public static final String KEY_LOCAL_URL = "localUrl";
    public static final String KEY_LOAD_STATUS = "loadStatus";
    public static final String KEY_RELATED_MESSAGE_ROW_ID = "relatedMessageRowID";
	public static final String KEY_LOCAL_URL_UPDATE_TIMESTAMP = "localUrlTimestamp";

	public enum LoadStatus{NOT_STARTED, PROCESSING, REQUESTING_URL, UPLOADING, DOWNLOADING, COMPLETED, FAILED, PREVIEW_ERROR, TOKEN_EXPIRED}

    @Override
    public String getCreateCommand() {
        return "create table " + FILES_TABLE + "(" +
                KEY_ID + " integer primary key autoincrement," +
                KEY_PREVIEW + " text," +
                KEY_SWIFT_PATH + " text," +
                KEY_FILE_TYPE + " text," +
                KEY_LOCAL_URL + " text," +
                KEY_LOAD_STATUS + " integer," +
                KEY_LOCAL_URL_UPDATE_TIMESTAMP + " big int," +
                KEY_RELATED_MESSAGE_ROW_ID + " integer default -1" +
                ");";
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        //TODO: Currently we drop the existing table, and create a new one
        //TODO: need to handle data migration when we will be in production
        if (oldVersion < 4){
            //Files table was added in version 4
            db.execSQL(getCreateCommand());
        }
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public String getTableName() {
        return FILES_TABLE;
    }
}